<?php

/**
 * Copyright (c) 2020 CodeLathe. All rights Reserved.
 * This file is part of FileCloud  https://www.filecloud.com
 */

require_once __DIR__ . DIRECTORY_SEPARATOR . 'MigrationInterface.php';

/**
 * Class MigrationBase
 */
abstract class MigrationBase implements MigrationInterface
{
    /**
     * @return array
     */
    abstract protected function getSupportedVersions(): array;

    /**
     * @param string $version
     * @return bool
     */
    public function shouldTarget(string $version): bool
    {
        $supportedVersions = $this->getSupportedVersions();
        foreach ($supportedVersions as $supportedVersion) {
            if ($this->startsWith($version, $supportedVersion)) {
                return true;
            }
        }

        return false;
    }

    /**
     * @param $haystack
     * @param $needle
     * @return bool
     */
    private function startsWith($haystack, $needle): bool
    {
        return substr_compare($haystack, $needle, 0, strlen($needle)) === 0 || substr_compare($needle, $haystack, 0, strlen($haystack)) === 0;
    }
}