<?php

/**
 * Copyright (c) 2020 CodeLathe. All rights Reserved.
 * This file is part of FileCloud  https://www.filecloud.com
 */

/**
 * Interface MigrationInterface
 */
interface MigrationInterface
{
    /**
     * Migration title
     *
     * @return string
     */
    public function getTitle(): string;

    /**
     * Can this migration target the specified FC version
     *
     * @return bool
     */
    public function shouldTarget(string $version): bool;

    /**
     * Perform migration
     */
    public function migrate(): void;
}
