# Pre-Upgrade Migrations

Migrations to be executed prior upgrading to the next FC version.

## Terms

* current version - The currently installed version
* next version - The version after upgrade

## How to use

1. preupgrade directory must be copied over to the current version/installation
2. Execute the preupgrade script

    ```
    /path/to/php /path/to/preupgrade.php
    ```
   
## How to add new migrations

1. Create a new migration class inside migrations directory
2. The new class should extend MigrationBase class and implement its abstract methods
3. The class can be named anything but to avoid naming collisions, the ff convention is recommended: `Y[year]R[release]M[migration]` e.g. for a migration for V20.1 the classname can be `Y20R1M0`