<?php

/**
 * Copyright (c) 2020 CodeLathe. All rights Reserved.
 * This file is part of FileCloud  https://www.filecloud.com
 */

if (php_sapi_name() !== 'cli') {
    echo 'This can only be run from the cli';
    exit(1);
}

use core\framework\SettingsDataStore;
use core\framework\SiteSetting;
use core\framework\MqDefs;
use core\framework\SettingsManager;
use core\framework\Utility;

define('TONIDO_CLOUD_ROOT_DIR', realpath(__DIR__ . '/../../..'));
require_once(TONIDO_CLOUD_ROOT_DIR.DIRECTORY_SEPARATOR .'core'.DIRECTORY_SEPARATOR .'framework'.DIRECTORY_SEPARATOR .'runtime.php');

// Check OS
$isOsWindows = (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN');

$isMultiTenant = defined("TONIDOCLOUD_MULTISITE_ENABLE") && (TONIDOCLOUD_MULTISITE_ENABLE == 1);
$siteArray = SettingsDataStore::getInstance()->getSiteSettings();
foreach ($siteArray as $siteItem) {
    try {
        $ss = SiteSetting::withDBData($siteItem);
        $hostname = $ss->getSiteHost();

        echo sprintf("HOST: %s\n", $hostname);
        if ($hostname !== '*' && !$isMultiTenant) {

            // For de-activated sites of a former multi-tenancy, simply clear all queue items!
            echo sprintf("Clearing all queue items for site %s", $hostname);
            deleteSiteMq($ss->getSiteName());
            continue;
        }

        drainSiteMq($hostname);
    } catch (\Throwable $t) {

        // Report error but try to continue to next site
        echo $t->getMessage() . "\n";
    }
}

function drainSiteMq(string $host) {
    $phpPath = guessPhpBin();
    $scriptPath = __DIR__ . '/drainmq.php';

    $cmdTemplate = sprintf('%s %s --host=%s --worker=%%s', $phpPath, $scriptPath, $host);

    // Drain serial
    $serialCmd = sprintf($cmdTemplate, MqDefs::SERIAL);
    system($serialCmd);

    // Drain parallel
    $parallelCmd = sprintf($cmdTemplate, MqDefs::PARALLEL);
    system($parallelCmd);
}

function guessPhpBin(): string {
    $defaultPhpPath = PHP_BINARY;
    $officialPhpPath = SettingsManager::getInstance()->getSetting("PHPBIN_PATH", "string", "");

    return !$officialPhpPath ? $defaultPhpPath : $officialPhpPath;
}

function deleteSiteMq(string $siteName) {
    $dbServer = SettingsManager::getInstance()->getSetting("TONIDOCLOUD_DBSERVER");
    $conn = Utility::getMongoConnection($dbServer);
    $db = $conn->selectDB("tonidoclouddb_{$siteName}");

    // Clear serial queue
    $collection = $db->selectCollection('background_queue');
    $collection->deleteMany([]);

    // Clear parallel queue
    $collection = $db->selectCollection('background_queue_parallel');
    $collection->deleteMany([]);
}