<?php

/**
 * Copyright (c) 2020 CodeLathe. All rights Reserved.
 * This file is part of FileCloud  https://www.filecloud.com
 */

if (php_sapi_name() !== 'cli') {
    echo 'This can only be run from the cli';
    exit(1);
}

use core\framework\MqDefs;

define('TONIDO_CLOUD_ROOT_DIR', realpath(__DIR__ . '/../../..'));
require_once(TONIDO_CLOUD_ROOT_DIR.DIRECTORY_SEPARATOR .'core'.DIRECTORY_SEPARATOR .'framework'.DIRECTORY_SEPARATOR .'runtime.php');
require_once(__DIR__ . '/mqdrainer.class.php');

// Capture options
$options = getopt('', ['host:', 'worker:']);
$siteHost = $options['host'] ?? null;
$worker = $options['worker'] ?? MqDefs::SERIAL;

// Check required
if (!$siteHost) {
    echo "ERROR: --host is required";
    exit(1);
}

// Check worker
if (!in_array($worker, [MqDefs::SERIAL, MqDefs::PARALLEL])) {
    echo "ERROR: --worker is invalid";
    exit(1);
}

// Mock request variables
$g_REQUEST["workerid"] = 'fcserveragent-cli';
$g_REQUEST["host"] = $siteHost;

// Drain queue
$g_REQUEST["workertype"] = $worker;
echo sprintf("Draining %s queue for %s ...\n", $worker, $siteHost);
$mqDrainer = new MqDrainer();
$mqDrainer->processWorkRequest();
echo sprintf("Draining %s queue is complete for %s\n", $worker, $siteHost);

