<?php

/**
 * Copyright (c) 2020 CodeLathe. All rights Reserved.
 * This file is part of FileCloud  https://www.filecloud.com
 */

if (php_sapi_name() !== 'cli') {
    echo 'This can only be run from the cli';
    exit(1);
}

define('TONIDO_CLOUD_ROOT_DIR', realpath(__DIR__ . '/../..'));
require_once __DIR__ . DIRECTORY_SEPARATOR . 'MigrationBase.php';

function getVersion() {
    // Pre 20.2 location
    $manifestFile = TONIDO_CLOUD_ROOT_DIR . DIRECTORY_SEPARATOR . 'core' . DIRECTORY_SEPARATOR . 'manifest.xml';
    if (!file_exists($manifestFile)) {
        // Check 20.2 location
        $manifestFile = TONIDO_CLOUD_ROOT_DIR . DIRECTORY_SEPARATOR . 'public' . DIRECTORY_SEPARATOR . 'manifest.xml';
    }

    if (!file_exists($manifestFile)) {
        echo "Could not determine current version of FileCloud installation!\n";
        exit(1);
    }

    $manifest = simplexml_load_file($manifestFile);
    $localVersion = (string) $manifest->Meta->Version;

    return $localVersion;
}

$opts = getopt('', ['migration:']);
$migrationClass = $opts['migration'] ?? null;

if (!$migrationClass) {
    echo "No migration specified for execution. Use --migration=Migration";
    exit(1);
}

$version = getVersion();
echo "Migrating version {$version} with {$migrationClass}\n";

try {
    $baseDir = __DIR__ . DIRECTORY_SEPARATOR . 'migrations' . DIRECTORY_SEPARATOR;
    require_once "{$baseDir}{$migrationClass}.php";

    /** @var MigrationBase $migration */
    $migration = new $migrationClass();
} catch (\Throwable $e) {
    echo sprintf("Problem with executing migration `%s`. Error: %s. Please reach out to the FileCloud support team at support@filecloud.com\n", $migrationClass, $e->getMessage());
    exit(1);
}

if ($migration->shouldTarget($version)) {
    try {
        $migration->migrate();
        echo "Migration {$migrationClass}[\"{$migration->getTitle()}\"] has completed!\n";
    } catch (\Throwable $t) {
        echo sprintf(
            "Failed to migrate %s for version %s with error: %s.\n",
            $migration->getTitle(),
            $version,
            $t->getMessage()
        );
        exit(1);
    }
}

echo "Migrating version {$version} with {$migrationClass} successful!\n";
