/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.api.endpoint;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.apache.solr.client.api.model.ZooKeeperFileResponse;
import org.apache.solr.client.api.model.ZooKeeperListChildrenResponse;

@Path(value="/cluster/zookeeper/")
public interface ZooKeeperReadApis {
    @GET
    @Path(value="/data{zkPath:.+}")
    @Operation(summary="Return the data stored in a specified ZooKeeper node", tags={"zookeeper-read"})
    @Produces(value={"application/vnd.apache.solr.raw", "application/json"})
    public ZooKeeperFileResponse readNode(@Parameter(description="The path of the node to read from ZooKeeper") @PathParam(value="zkPath") String var1);

    @GET
    @Path(value="/data/security.json")
    @Produces(value={"application/vnd.apache.solr.raw", "application/json"})
    public ZooKeeperFileResponse readSecurityJsonNode();

    @GET
    @Path(value="/children{zkPath:.*}")
    @Produces(value={"application/json", "application/javabin"})
    @Operation(summary="List and stat all children of a specified ZooKeeper node", tags={"zookeeper-read"})
    public ZooKeeperListChildrenResponse listNodes(@Parameter(description="The path of the ZooKeeper node to stat and list children of") @PathParam(value="zkPath") String var1, @Parameter(description="Controls whether stat information for child nodes is included in the response. 'true' by default.") @QueryParam(value="children") Boolean var2) throws Exception;
}

