/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.debugger.treestatus.TreeStatus;
import org.apache.pdfbox.debugger.ui.ArrayEntry;
import org.apache.pdfbox.debugger.ui.FileOpenSaveDialog;
import org.apache.pdfbox.debugger.ui.MapEntry;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.common.PDStream;

public class Tree
extends JTree {
    private final JPopupMenu treePopupMenu = new JPopupMenu();
    private final Component parent;
    private final Object rootNode;

    public Tree(Component parentComponent) {
        this.setComponentPopupMenu(this.treePopupMenu);
        this.parent = parentComponent;
        this.rootNode = this.getModel().getRoot();
    }

    @Override
    public Point getPopupLocation(MouseEvent event) {
        if (event != null) {
            TreePath path = this.getClosestPathForLocation(event.getX(), event.getY());
            this.setSelectionPath(path);
            this.treePopupMenu.removeAll();
            for (JMenuItem menuItem : this.getPopupMenuItems(path)) {
                this.treePopupMenu.add(menuItem);
            }
            return event.getPoint();
        }
        return null;
    }

    private List<JMenuItem> getPopupMenuItems(TreePath nodePath) {
        Object obj = nodePath.getLastPathComponent();
        ArrayList<JMenuItem> menuItems = new ArrayList<JMenuItem>();
        menuItems.add(this.getTreePathMenuItem(nodePath));
        if (obj instanceof MapEntry) {
            obj = ((MapEntry)obj).getValue();
        } else if (obj instanceof ArrayEntry) {
            obj = ((ArrayEntry)obj).getValue();
        }
        if (obj instanceof COSStream) {
            COSStream stream = (COSStream)obj;
            menuItems.add(this.getUnFilteredStreamSaveMenu(stream));
            if (stream.getFilters() != null) {
                if (stream.getFilters() instanceof COSArray && ((COSArray)stream.getFilters()).size() >= 2) {
                    for (JMenuItem menuItem : this.getPartiallyFilteredStreamSaveMenu(stream)) {
                        menuItems.add(menuItem);
                    }
                }
                menuItems.add(this.getFilteredStreamSaveMenu(stream));
            }
        }
        return menuItems;
    }

    private JMenuItem getTreePathMenuItem(final TreePath path) {
        JMenuItem copyPathMenuItem = new JMenuItem("Copy Tree Path");
        copyPathMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(new TreeStatus(Tree.this.rootNode).getStringForPath(path)), null);
            }
        });
        return copyPathMenuItem;
    }

    private JMenuItem getFilteredStreamSaveMenu(final COSStream cosStream) {
        JMenuItem saveMenuItem = new JMenuItem("Save Filtered Stream (" + this.getFilters(cosStream) + ")...");
        saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    byte[] bytes = IOUtils.toByteArray(cosStream.createRawInputStream());
                    Tree.this.saveStream(bytes);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        return saveMenuItem;
    }

    private String getFilters(COSStream cosStream) {
        StringBuilder sb = new StringBuilder();
        COSBase filters = cosStream.getFilters();
        if (filters != null) {
            if (filters instanceof COSName) {
                sb.append(((COSName)filters).getName());
            } else if (filters instanceof COSArray) {
                COSArray filterArray = (COSArray)filters;
                for (int i = 0; i < filterArray.size(); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(((COSName)filterArray.get(i)).getName());
                }
            }
        }
        return sb.toString();
    }

    private JMenuItem getUnFilteredStreamSaveMenu(final COSStream cosStream) {
        JMenuItem saveMenuItem = new JMenuItem("Save Unfiltered Stream...");
        saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    byte[] bytes = IOUtils.toByteArray(cosStream.createInputStream());
                    Tree.this.saveStream(bytes);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        return saveMenuItem;
    }

    private List<JMenuItem> getPartiallyFilteredStreamSaveMenu(COSStream cosStream) {
        ArrayList<JMenuItem> menuItems = new ArrayList<JMenuItem>();
        PDStream stream = new PDStream(cosStream);
        List<COSName> filters = stream.getFilters();
        for (int i = filters.size() - 1; i >= 1; --i) {
            menuItems.add(this.getPartialStreamSavingMenuItem(i, stream));
        }
        return menuItems;
    }

    private JMenuItem getPartialStreamSavingMenuItem(int indexOfStopFilter, final PDStream stream) {
        List<COSName> filters = stream.getFilters();
        final ArrayList<String> stopFilters = new ArrayList<String>(1);
        stopFilters.add(filters.get(indexOfStopFilter).getName());
        StringBuilder nameListBuilder = new StringBuilder();
        for (int i = indexOfStopFilter; i < filters.size(); ++i) {
            nameListBuilder.append(filters.get(i).getName()).append(" & ");
        }
        nameListBuilder.delete(nameListBuilder.lastIndexOf("&"), nameListBuilder.length());
        JMenuItem menuItem = new JMenuItem("Keep " + nameListBuilder.toString() + "...");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    InputStream data = stream.createInputStream(stopFilters);
                    Tree.this.saveStream(IOUtils.toByteArray(data));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        return menuItem;
    }

    private void saveStream(byte[] bytes) throws IOException {
        FileOpenSaveDialog saveDialog = new FileOpenSaveDialog(this.parent, null);
        saveDialog.saveFile(bytes);
    }
}

