/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.DeprecatedAttributes;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.client.solrj.impl.SolrZkClientTimeout;
import org.apache.solr.cloud.SolrZkServer;
import org.apache.solr.cloud.ZkConfigSetService;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterProperties;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkMaintenanceUtils;
import org.apache.solr.common.util.Compressor;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.ZLibCompressor;
import org.apache.solr.core.ConfigSetService;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.NodeConfig;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.xml.sax.SAXException;

public class ZkCLI
implements CLIO {
    private static final String MAKEPATH = "makepath";
    private static final String PUT = "put";
    private static final String PUT_FILE = "putfile";
    private static final String GET = "get";
    private static final String GET_FILE = "getfile";
    private static final String DOWNCONFIG = "downconfig";
    private static final String ZK_CLI_NAME = "ZkCLI";
    private static final String LINKCONFIG = "linkconfig";
    @Deprecated(since="9.7")
    private static final String CONFDIR = "confdir";
    private static final String CONF_DIR = "conf-dir";
    @Deprecated(since="9.7")
    private static final String CONFNAME = "confname";
    private static final String CONF_NAME = "conf-name";
    @Deprecated(since="9.7")
    private static final String ZKHOST = "zkhost";
    private static final String ZK_HOST = "zk-host";
    @Deprecated(since="9.7")
    private static final String RUNZK = "runzk";
    private static final String RUN_ZK = "run-zk";
    @Deprecated(since="9.7")
    private static final String SOLRHOME = "solrhome";
    private static final String SOLR_HOME = "solr-home";
    private static final String BOOTSTRAP = "bootstrap";
    static final String UPCONFIG = "upconfig";
    static final String EXCLUDE_REGEX_SHORT = "x";
    @Deprecated(since="9.7")
    static final String EXCLUDEREGEX = "excluderegex";
    static final String EXCLUDE_REGEX = "exclude-regex";
    static final String EXCLUDE_REGEX_DEFAULT = "^\\..*$";
    private static final String COLLECTION = "collection";
    private static final String CLEAR = "clear";
    private static final String LIST = "list";
    private static final String LS = "ls";
    private static final String CMD = "cmd";
    private static final String CLUSTERPROP = "clusterprop";
    private static final String UPDATEACLS = "updateacls";
    private static PrintStream stdout = CLIO.getOutStream();

    @VisibleForTesting
    public static void setStdout(PrintStream stdout) {
        ZkCLI.stdout = stdout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException, TimeoutException, IOException, ParserConfigurationException, SAXException, KeeperException {
        DefaultParser parser = DefaultParser.builder().setDeprecatedHandler(SolrCLI::deprecatedHandlerStdErr).build();
        Options options = new Options();
        Option cmdOption = Option.builder((String)CMD).hasArg(true).desc("cmd to run: bootstrap, upconfig, downconfig, linkconfig, makepath, put, putfile,get,getfile, list, clear, updateacls, ls").build();
        options.addOption(cmdOption);
        Option zkHostDepOption = Option.builder((String)ZKHOST).argName("zkHost").hasArg().desc("ZooKeeper host address").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.7").setDescription("Use --zk-host instead").get()).build();
        options.addOption(zkHostDepOption);
        Option zkHostOption = Option.builder((String)"z").longOpt(ZK_HOST).argName("zkHost").hasArg().desc("ZooKeeper host address").build();
        options.addOption(zkHostOption);
        Option solrHomeDepOption = Option.builder((String)SOLRHOME).hasArg().desc("for bootstrap, runzk: solrhome location").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.7").setDescription("Use --solr-home instead").get()).build();
        options.addOption(solrHomeDepOption);
        Option solrHomeOption = Option.builder((String)"s").longOpt(SOLR_HOME).hasArg().desc("for bootstrap, runzk: solr-home location").build();
        options.addOption(solrHomeOption);
        Option confDirDepOption = Option.builder((String)CONFDIR).hasArg().argName("DIR").desc("for upconfig: a directory of configuration files").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.7").setDescription("Use --conf-dir instead").get()).build();
        options.addOption(confDirDepOption);
        Option confDirOption = Option.builder((String)"d").longOpt(CONF_DIR).hasArg().argName("DIR").desc("for upconfig: a directory of configuration files").build();
        options.addOption(confDirOption);
        Option confNameDepOption = Option.builder((String)CONFNAME).hasArg().argName("NAME").desc("for upconfig, linkconfig: name of the config set").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.7").setDescription("Use --conf-name instead").get()).build();
        options.addOption(confNameDepOption);
        Option confNameOption = Option.builder((String)"n").longOpt(CONF_NAME).hasArg().argName("NAME").desc("for upconfig, linkconfig: name of the config set").build();
        options.addOption(confNameOption);
        Option collectionOption = Option.builder((String)"c").longOpt(COLLECTION).hasArg().argName("NAME").desc("for linkconfig: name of the collection").build();
        options.addOption(collectionOption);
        Option excludeRegexDepOption = Option.builder((String)EXCLUDEREGEX).hasArg().argName("<true/false>").desc("for upconfig: files matching this regular expression won't be uploaded").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.7").setDescription("Use --exclude-regex instead").get()).build();
        options.addOption(excludeRegexDepOption);
        Option excludeRegexOption = Option.builder((String)EXCLUDE_REGEX_SHORT).longOpt(EXCLUDE_REGEX).hasArg().argName("<true/false>").desc("for upconfig: files matching this regular expression won't be uploaded").build();
        options.addOption(excludeRegexOption);
        Option runZkDepOption = Option.builder((String)RUNZK).hasArg().argName("<true/false>").desc("run zk internally by passing the solr run port - only for clusters on one machine (tests, dev)").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.7").setDescription("Use --run-zk instead").get()).build();
        options.addOption(runZkDepOption);
        Option runZkOption = Option.builder((String)"r").longOpt(RUN_ZK).hasArg().argName("<true/false>").desc("run zk internally by passing the solr run port - only for clusters on one machine (tests, dev)").build();
        options.addOption(runZkOption);
        Option clusterNameOption = Option.builder((String)"name").hasArg().desc("name of the cluster property to set").build();
        options.addOption(clusterNameOption);
        Option clusterValueOption = Option.builder((String)"val").hasArg().desc("value of the cluster to set").build();
        options.addOption(clusterValueOption);
        options.addOption(SolrCLI.OPTION_HELP);
        options.addOption(SolrCLI.OPTION_VERBOSE);
        try {
            String solrHome;
            CommandLine line = parser.parse(options, args);
            if (!(!line.hasOption(SolrCLI.OPTION_HELP) && (line.hasOption(ZK_HOST) || line.hasOption(ZKHOST)) && line.hasOption(CMD) || line.hasOption(SolrCLI.OPTION_VERBOSE))) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp(ZK_CLI_NAME, options);
                stdout.println("Examples:");
                stdout.println("zkcli.sh --zk-host localhost:9983 -cmd bootstrap --solr-home /opt/solr");
                stdout.println("zkcli.sh --zk-host localhost:9983 -cmd upconfig --conf-dir /opt/solr/collection1/conf --conf-name myconf");
                stdout.println("zkcli.sh --zk-host localhost:9983 -cmd downconfig --conf-dir /opt/solr/collection1/conf --conf-name myconf");
                stdout.println("zkcli.sh --zk-host localhost:9983 -cmd linkconfig --collection collection1 --conf-name myconf");
                stdout.println("zkcli.sh --zk-host localhost:9983 -cmd makepath /apache/solr");
                stdout.println("zkcli.sh --zk-host localhost:9983 -cmd put /solr.conf 'conf data'");
                stdout.println("zkcli.sh --zk-host localhost:9983 -cmd putfile /solr.xml /User/myuser/solr/solr.xml");
                stdout.println("zkcli.sh --zk-host localhost:9983 -cmd get /solr.xml");
                stdout.println("zkcli.sh --zk-host localhost:9983 -cmd getfile /solr.xml solr.xml.file");
                stdout.println("zkcli.sh --zk-host localhost:9983 -cmd clear /solr");
                stdout.println("zkcli.sh --zk-host localhost:9983 -cmd list");
                stdout.println("zkcli.sh --zk-host localhost:9983 -cmd ls /solr/live_nodes");
                stdout.println("zkcli.sh --zk-host localhost:9983 -cmd clusterprop --name urlScheme --val https");
                stdout.println("zkcli.sh --zk-host localhost:9983 -cmd updateacls /solr");
                return;
            }
            String zkServerAddress = line.hasOption(ZK_HOST) ? line.getOptionValue(ZK_HOST) : line.getOptionValue(ZKHOST);
            String string = solrHome = line.hasOption(SOLR_HOME) ? line.getOptionValue(SOLR_HOME) : line.getOptionValue(SOLRHOME);
            if (StrUtils.isNullOrEmpty((String)solrHome)) {
                solrHome = System.getProperty("solr.home");
            }
            if (line.hasOption(SolrCLI.OPTION_VERBOSE)) {
                stdout.println("Using solrhome=" + solrHome);
                return;
            }
            String solrPort = null;
            if (line.hasOption(RUNZK) || line.hasOption(RUN_ZK)) {
                if (!line.hasOption(SOLR_HOME) && !line.hasOption(SOLRHOME)) {
                    stdout.println("--solr-home is required for run-zk");
                    System.exit(1);
                }
                solrPort = line.hasOption(RUN_ZK) ? line.getOptionValue(RUN_ZK) : line.getOptionValue(RUNZK);
            }
            SolrZkServer zkServer = null;
            if (solrPort != null) {
                zkServer = new SolrZkServer("true", null, new File(solrHome, "/zoo_data"), solrHome, Integer.parseInt(solrPort));
                zkServer.parseConfig();
                zkServer.start();
            }
            int minStateByteLenForCompression = -1;
            ZLibCompressor compressor = new ZLibCompressor();
            if (solrHome != null) {
                try {
                    Path solrHomePath = Paths.get(solrHome, new String[0]);
                    Properties props = new Properties();
                    props.put("zkHost", zkServerAddress);
                    NodeConfig nodeConfig = NodeConfig.loadNodeConfig(solrHomePath, props);
                    minStateByteLenForCompression = nodeConfig.getCloudConfig().getMinStateByteLenForCompression();
                    String stateCompressorClass = nodeConfig.getCloudConfig().getStateCompressorClass();
                    if (StrUtils.isNotNullOrEmpty((String)stateCompressorClass)) {
                        Class<Compressor> compressionClass = Class.forName(stateCompressorClass).asSubclass(Compressor.class);
                        compressor = compressionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                }
                catch (SolrException e) {
                    stdout.println("Failed to load solr.xml from ZK or SolrHome, put/get operations on compressed data will use data as is. If you intention is to read and de-compress data or compress and write data, then solr.xml must be accessible.");
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    stdout.println("Unable to find or instantiate compression class: " + e.getMessage());
                    System.exit(1);
                }
            }
            try (SolrZkClient zkClient = new SolrZkClient.Builder().withUrl(zkServerAddress).withTimeout(SolrZkClientTimeout.DEFAULT_ZK_CLIENT_TIMEOUT, TimeUnit.MILLISECONDS).withConnTimeOut(SolrZkClientTimeout.DEFAULT_ZK_CONNECT_TIMEOUT, TimeUnit.MILLISECONDS).withReconnectListener(() -> {}).withStateFileCompression(minStateByteLenForCompression, (Compressor)compressor).build();){
                byte[] data;
                byte[] data2;
                String path;
                List arglist;
                String confName;
                String confDir;
                if (line.getOptionValue(CMD).equalsIgnoreCase(BOOTSTRAP)) {
                    if (!line.hasOption(SOLR_HOME) && !line.hasOption(SOLRHOME)) {
                        stdout.println("--solr-home is required for bootstrap");
                        System.exit(1);
                    }
                    CoreContainer cc = new CoreContainer(Paths.get(solrHome, new String[0]), new Properties());
                    cc.setCoreConfigService(new ZkConfigSetService(zkClient));
                    if (!ZkController.checkChrootPath(zkServerAddress, true)) {
                        stdout.println("A chroot was specified in zkHost but the znode doesn't exist. ");
                        System.exit(1);
                    }
                    ConfigSetService.bootstrapConf(cc);
                } else if (line.getOptionValue(CMD).equalsIgnoreCase(UPCONFIG)) {
                    String excludeExpr;
                    if (!line.hasOption(CONF_DIR) && !line.hasOption(CONFDIR) || !line.hasOption(CONF_NAME) && !line.hasOption(CONFNAME)) {
                        stdout.println("--conf-dir and --conf-name are required for upconfig");
                        System.exit(1);
                    }
                    confDir = line.hasOption(CONF_DIR) ? line.getOptionValue(CONF_DIR) : line.getOptionValue(CONFDIR);
                    confName = line.hasOption(CONF_NAME) ? line.getOptionValue(CONF_NAME) : line.getOptionValue(CONFNAME);
                    String string2 = excludeExpr = line.hasOption(EXCLUDE_REGEX) ? line.getOptionValue(EXCLUDE_REGEX, EXCLUDE_REGEX_DEFAULT) : line.getOptionValue(EXCLUDEREGEX, EXCLUDE_REGEX_DEFAULT);
                    if (!ZkController.checkChrootPath(zkServerAddress, true)) {
                        stdout.println("A chroot was specified in zkHost but the znode doesn't exist. ");
                        System.exit(1);
                    }
                    Pattern excludePattern = Pattern.compile(excludeExpr);
                    ZkMaintenanceUtils.uploadToZK((SolrZkClient)zkClient, (Path)Paths.get(confDir, new String[0]), (String)("/configs/" + confName), (Pattern)excludePattern);
                } else if (line.getOptionValue(CMD).equalsIgnoreCase(DOWNCONFIG)) {
                    if (!line.hasOption(CONF_DIR) && !line.hasOption(CONFDIR) || !line.hasOption(CONF_NAME) && !line.hasOption(CONFNAME)) {
                        stdout.println("--conf-dir and --conf-name are required for downconfig");
                        System.exit(1);
                    }
                    confDir = line.hasOption(CONF_DIR) ? line.getOptionValue(CONF_DIR) : line.getOptionValue(CONFDIR);
                    confName = line.hasOption(CONF_NAME) ? line.getOptionValue(CONF_NAME) : line.getOptionValue(CONFNAME);
                    ZkMaintenanceUtils.downloadFromZK((SolrZkClient)zkClient, (String)("/configs/" + confName), (Path)Paths.get(confDir, new String[0]));
                } else if (line.getOptionValue(CMD).equalsIgnoreCase(LINKCONFIG)) {
                    if (!line.hasOption(COLLECTION) || !line.hasOption(CONF_NAME) && !line.hasOption(CONFNAME)) {
                        stdout.println("--collection and --conf-name are required for linkconfig");
                        System.exit(1);
                    }
                    String collection = line.getOptionValue(COLLECTION);
                    confName = line.hasOption(CONF_NAME) ? line.getOptionValue(CONF_NAME) : line.getOptionValue(CONFNAME);
                    ZkController.linkConfSet(zkClient, collection, confName);
                } else if (line.getOptionValue(CMD).equalsIgnoreCase(LIST)) {
                    zkClient.printLayoutToStream(stdout);
                } else if (line.getOptionValue(CMD).equals(LS)) {
                    List argList = line.getArgList();
                    if (argList.size() != 1) {
                        stdout.println("-ls requires one arg - the path to list");
                        System.exit(1);
                    }
                    StringBuilder sb = new StringBuilder();
                    String path2 = (String)argList.get(0);
                    zkClient.printLayout(path2 == null ? "/" : path2, 0, sb);
                    stdout.println(sb);
                } else if (line.getOptionValue(CMD).equalsIgnoreCase(CLEAR)) {
                    arglist = line.getArgList();
                    if (arglist.size() != 1) {
                        stdout.println("-clear requires one arg - the path to clear");
                        System.exit(1);
                    }
                    zkClient.clean((String)arglist.get(0));
                } else if (line.getOptionValue(CMD).equalsIgnoreCase(MAKEPATH)) {
                    arglist = line.getArgList();
                    if (arglist.size() != 1) {
                        stdout.println("-makepath requires one arg - the path to make");
                        System.exit(1);
                    }
                    if (!ZkController.checkChrootPath(zkServerAddress, true)) {
                        stdout.println("A chroot was specified in zkHost but the znode doesn't exist. ");
                        System.exit(1);
                    }
                    zkClient.makePath((String)arglist.get(0), true);
                } else if (line.getOptionValue(CMD).equalsIgnoreCase(PUT)) {
                    arglist = line.getArgList();
                    if (arglist.size() != 2) {
                        stdout.println("-put requires two args - the path to create and the data string");
                        System.exit(1);
                    }
                    path = (String)arglist.get(0);
                    data2 = ((String)arglist.get(1)).getBytes(StandardCharsets.UTF_8);
                    if (ZkCLI.shouldCompressData(data2, path, minStateByteLenForCompression)) {
                        // empty if block
                    }
                    if (zkClient.exists(path, true).booleanValue()) {
                        zkClient.setData(path, data2, true);
                    } else {
                        zkClient.makePath(path, data2, CreateMode.PERSISTENT, true);
                    }
                } else if (line.getOptionValue(CMD).equalsIgnoreCase(PUT_FILE)) {
                    arglist = line.getArgList();
                    if (arglist.size() != 2) {
                        stdout.println("-putfile requires two args - the path to create in ZK and the path to the local file");
                        System.exit(1);
                    }
                    path = (String)arglist.get(0);
                    data2 = Files.readAllBytes(Path.of((String)arglist.get(1), new String[0]));
                    if (ZkCLI.shouldCompressData(data2, path, minStateByteLenForCompression)) {
                        // empty if block
                    }
                    if (zkClient.exists(path, true).booleanValue()) {
                        zkClient.setData(path, data2, true);
                    } else {
                        if (!ZkController.checkChrootPath(zkServerAddress, true)) {
                            stdout.println("A chroot was specified in zkHost but the znode doesn't exist. ");
                            System.exit(1);
                        }
                        zkClient.makePath(path, data2, CreateMode.PERSISTENT, true);
                    }
                } else if (line.getOptionValue(CMD).equalsIgnoreCase(GET)) {
                    arglist = line.getArgList();
                    if (arglist.size() != 1) {
                        stdout.println("-get requires one arg - the path to get");
                        System.exit(1);
                    }
                    data = zkClient.getData((String)arglist.get(0), null, null, true);
                    stdout.println(new String(data, StandardCharsets.UTF_8));
                } else if (line.getOptionValue(CMD).equalsIgnoreCase(GET_FILE)) {
                    arglist = line.getArgList();
                    if (arglist.size() != 2) {
                        stdout.println("-getfilerequires two args - the path to get and the file to save it to");
                        System.exit(1);
                    }
                    data = zkClient.getData((String)arglist.get(0), null, null, true);
                    Files.write(Path.of((String)arglist.get(1), new String[0]), data, new OpenOption[0]);
                } else if (line.getOptionValue(CMD).equals(UPDATEACLS)) {
                    arglist = line.getArgList();
                    if (arglist.size() != 1) {
                        stdout.println("-updateacls requires one arg - the path to update");
                        System.exit(1);
                    }
                    zkClient.updateACLs((String)arglist.get(0));
                } else if (line.getOptionValue(CMD).equalsIgnoreCase(CLUSTERPROP)) {
                    if (!line.hasOption("name")) {
                        stdout.println("-name is required for clusterprop");
                    }
                    if (!ZkController.checkChrootPath(zkServerAddress, true)) {
                        stdout.println("A chroot was specified in zkHost but the znode doesn't exist. ");
                        System.exit(1);
                    }
                    String propertyName = line.getOptionValue("name");
                    String propertyValue = line.getOptionValue("val");
                    ClusterProperties props = new ClusterProperties(zkClient);
                    try {
                        props.setClusterProperty(propertyName, (Object)propertyValue);
                    }
                    catch (IOException ex) {
                        stdout.println("Unable to set the cluster property due to following error : " + ex.getLocalizedMessage());
                        System.exit(1);
                    }
                } else {
                    stdout.println("Unknown command " + line.getOptionValue(CMD) + ". Use -h to get help.");
                    System.exit(1);
                }
            }
            finally {
                if (solrPort != null) {
                    zkServer.stop();
                }
            }
        }
        catch (ParseException exp) {
            stdout.println("Unexpected exception:" + exp.getMessage());
        }
    }

    private static boolean shouldCompressData(byte[] data, String path, int minStateByteLenForCompression) {
        return path.endsWith("state.json") && minStateByteLenForCompression > -1 && data.length > minStateByteLenForCompression;
    }
}

