/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.StandardDirectoryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MMapDirectoryFactory
extends StandardDirectoryFactory {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    boolean preload;
    private long maxChunk;

    @Override
    public void init(NamedList<?> args) {
        super.init(args);
        SolrParams params = args.toSolrParams();
        this.maxChunk = params.getLong("maxChunkSize", MMapDirectory.DEFAULT_MAX_CHUNK_SIZE);
        if (this.maxChunk <= 0L) {
            throw new IllegalArgumentException("maxChunk must be greater than 0");
        }
        if (params.get("unmap") != null) {
            log.warn("It is no longer possible to configure unmapping of index files on DirectoryFactory level in solrconfig.xml.");
            log.warn("To disable unmapping, pass -Dorg.apache.lucene.store.MMapDirectory.enableUnmapHack=false on Solr's command line.");
        }
        this.preload = params.getBool("preload", false);
    }

    @Override
    protected Directory create(String path, LockFactory lockFactory, DirectoryFactory.DirContext dirContext) throws IOException {
        MMapDirectory mapDirectory = new MMapDirectory(Path.of(path, new String[0]), lockFactory, this.maxChunk);
        mapDirectory.setPreload(this.preload);
        return mapDirectory;
    }
}

