/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.designer;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.solr.common.SolrInputDocument;

public class SampleDocuments {
    public static final SampleDocuments NONE = new SampleDocuments(null, null, null);
    public final String contentType;
    public final String fileSource;
    public List<SolrInputDocument> parsed;

    public SampleDocuments(List<SolrInputDocument> parsed, String contentType, String fileSource) {
        this.parsed = parsed != null ? parsed : new ArrayList();
        this.contentType = contentType;
        this.fileSource = fileSource;
    }

    public String getSource() {
        return this.fileSource != null ? this.fileSource : "paste";
    }

    private boolean isTextContentType() {
        if (this.contentType == null) {
            return false;
        }
        return this.contentType.contains("application/json") || this.contentType.startsWith("text/") || this.contentType.contains("application/xml");
    }

    public List<SolrInputDocument> appendDocs(String idFieldName, List<SolrInputDocument> add, int maxDocsToLoad) {
        if (add != null && !add.isEmpty()) {
            Set ids = this.parsed.stream().map(doc -> doc.getFieldValue(idFieldName)).filter(Objects::nonNull).collect(Collectors.toSet());
            List toAdd = add.stream().filter(doc -> {
                Object id = doc.getFieldValue(idFieldName);
                return id != null && !ids.contains(id);
            }).collect(Collectors.toList());
            this.parsed.addAll(toAdd);
            if (maxDocsToLoad > 0 && this.parsed.size() > maxDocsToLoad) {
                this.parsed = this.parsed.subList(0, maxDocsToLoad);
            }
        }
        return this.parsed;
    }
}

