/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho;

import org.jfree.report.ReportData;
import org.libreoffice.report.DataSource;
import org.libreoffice.report.DataSourceException;

public class StarReportData
implements ReportData {
    private final DataSource dataSource;
    private int currentRow;
    private final int rowCount;

    public StarReportData(DataSource dataSource) throws DataSourceException {
        if (dataSource == null) {
            throw new NullPointerException();
        }
        this.dataSource = dataSource;
        this.currentRow = 0;
        this.rowCount = dataSource.getRowCount();
    }

    @Override
    public boolean setCursorPosition(int row) throws org.jfree.report.DataSourceException {
        try {
            boolean ret = this.dataSource.absolute(row);
            if (ret) {
                this.currentRow = row;
            }
            return ret;
        }
        catch (DataSourceException e) {
            throw new org.jfree.report.DataSourceException("Failed to move cursor", e);
        }
    }

    @Override
    public void close() throws org.jfree.report.DataSourceException {
        try {
            this.dataSource.close();
        }
        catch (DataSourceException e) {
            throw new org.jfree.report.DataSourceException("Failed to close datasource", e);
        }
    }

    @Override
    public int getCursorPosition() throws org.jfree.report.DataSourceException {
        return this.currentRow;
    }

    @Override
    public boolean isAdvanceable() throws org.jfree.report.DataSourceException {
        return this.currentRow < this.rowCount;
    }

    @Override
    public boolean next() throws org.jfree.report.DataSourceException {
        try {
            if (this.dataSource.next()) {
                ++this.currentRow;
                return true;
            }
            return false;
        }
        catch (DataSourceException e) {
            throw new org.jfree.report.DataSourceException("Failed to move cursor", e);
        }
    }

    @Override
    public Object get(int column) throws org.jfree.report.DataSourceException {
        if (!this.isReadable()) {
            throw new org.jfree.report.DataSourceException("Failed to query column.");
        }
        try {
            return this.dataSource.getObject(column + 1);
        }
        catch (DataSourceException e) {
            throw new org.jfree.report.DataSourceException("Failed to query column.", e);
        }
    }

    @Override
    public int getColumnCount() throws org.jfree.report.DataSourceException {
        try {
            return this.dataSource.getColumnCount();
        }
        catch (DataSourceException e) {
            throw new org.jfree.report.DataSourceException("Failed to query column count.", e);
        }
    }

    @Override
    public String getColumnName(int column) throws org.jfree.report.DataSourceException {
        try {
            return this.dataSource.getColumnName(column + 1);
        }
        catch (DataSourceException e) {
            throw new org.jfree.report.DataSourceException("Failed to query column name.", e);
        }
    }

    @Override
    public boolean isReadable() throws org.jfree.report.DataSourceException {
        return this.currentRow > 0 && this.rowCount > 0;
    }
}

