/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.layoutprocessor;

import java.util.logging.Logger;
import org.jfree.report.DataFlags;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.expressions.FormulaExpression;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.structure.Element;
import org.libreoffice.report.pentaho.layoutprocessor.AbstractReportElementLayoutController;
import org.libreoffice.report.pentaho.layoutprocessor.FormatValueUtility;
import org.libreoffice.report.pentaho.layoutprocessor.TableCellLayoutController;
import org.libreoffice.report.pentaho.model.FormattedTextElement;
import org.pentaho.reporting.libraries.formula.Formula;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.parser.ParseException;

public class FormattedTextLayoutController
extends AbstractReportElementLayoutController {
    private static final Logger LOGGER = Logger.getLogger(FormattedTextLayoutController.class.getName());

    @Override
    public boolean isValueChanged() {
        try {
            FormattedTextElement element = (FormattedTextElement)this.getNode();
            FormulaExpression formulaExpression = element.getValueExpression();
            if (formulaExpression.getFormulaExpression() == null) {
                return false;
            }
            Formula formula = formulaExpression.getCompiledFormula();
            LValue lValue = formula.getRootReference();
            return FormatValueUtility.isReferenceChanged(this, lValue);
        }
        catch (ParseException e) {
            LOGGER.config("Parse Exception: " + (Object)((Object)e));
            return false;
        }
    }

    @Override
    protected LayoutController delegateContentGeneration(ReportTarget target) throws ReportProcessingException, ReportDataFactoryException, DataSourceException {
        FormattedTextElement element = (FormattedTextElement)this.getNode();
        DataFlags df = FormatValueUtility.computeDataFlag(element, this.getFlowController());
        if (df != null) {
            if (df.getValue() instanceof String) {
                target.processContent(df);
            } else {
                Element cell = this.getParentTableCell();
                if (cell != null && "string".equals(cell.getAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type"))) {
                    target.processContent(df);
                }
            }
        }
        return this.join(this.getFlowController());
    }

    private Element getParentTableCell() {
        for (LayoutController parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof TableCellLayoutController)) continue;
            TableCellLayoutController cellController = (TableCellLayoutController)parent;
            return cellController.getElement();
        }
        return null;
    }
}

