/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.layoutprocessor;

import java.util.logging.Logger;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.data.GlobalMasterRow;
import org.jfree.report.data.ReportDataRow;
import org.jfree.report.expressions.FormulaExpression;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.flow.layoutprocessor.LayoutControllerUtil;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Node;
import org.jfree.report.structure.Section;
import org.jfree.report.util.TextUtilities;
import org.libreoffice.report.pentaho.layoutprocessor.AbstractReportElementLayoutController;
import org.libreoffice.report.pentaho.layoutprocessor.FormatValueUtility;
import org.libreoffice.report.pentaho.layoutprocessor.ImageElementContext;
import org.libreoffice.report.pentaho.model.ImageElement;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.formula.Formula;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.parser.ParseException;

public class ImageElementLayoutController
extends AbstractReportElementLayoutController {
    private static final Logger LOGGER = Logger.getLogger(ImageElementLayoutController.class.getName());
    private ImageElementContext context;

    @Override
    protected LayoutController delegateContentGeneration(ReportTarget target) throws ReportProcessingException, ReportDataFactoryException, DataSourceException {
        ImageElement imageElement = (ImageElement)this.getNode();
        FormulaExpression formulaExpression = imageElement.getFormula();
        if (formulaExpression == null) {
            String linkTarget = imageElement.getImageData();
            this.generateImage(target, linkTarget, imageElement.getScaleMode(), imageElement.isPreserveIRI());
        } else {
            Object value = LayoutControllerUtil.evaluateExpression(this.getFlowController(), imageElement, formulaExpression);
            this.generateImage(target, value, imageElement.getScaleMode(), imageElement.isPreserveIRI());
        }
        return this.join(this.getFlowController());
    }

    private void generateImage(ReportTarget target, Object linkTarget, String scale, boolean preserveIri) throws ReportProcessingException, DataSourceException {
        if (linkTarget == null) {
            return;
        }
        AttributeMap image = new AttributeMap();
        image.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "namespace", (Object)"http://jfreereport.sourceforge.net/namespaces/engine");
        image.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "type", (Object)"image");
        image.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "scale", (Object)scale);
        image.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "preserve-IRI", (Object)String.valueOf(preserveIri));
        image.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "image-context", (Object)this.createContext());
        image.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "image-data", linkTarget);
        target.startElement(image);
        target.endElement(image);
    }

    protected ImageElementContext createContext() {
        if (this.context == null) {
            LayoutController cellController = this.findParentCell();
            if (cellController == null) {
                LOGGER.warning("Image is not contained in a table. Unable to calculate the image-size.");
                return null;
            }
            Element tableCell = (Element)cellController.getNode();
            int rowSpan = TextUtilities.parseInt((String)tableCell.getAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "number-rows-spanned"), 1);
            int colSpan = TextUtilities.parseInt((String)tableCell.getAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "number-columns-spanned"), 1);
            if (rowSpan < 1 || colSpan < 1) {
                LOGGER.warning("Rowspan or colspan for image-size calculation was invalid.");
                return null;
            }
            LayoutController rowController = cellController.getParent();
            if (rowController == null) {
                LOGGER.warning("Table-Cell has no parent. Unable to calculate the image-size.");
                return null;
            }
            Section tableRow = (Section)rowController.getNode();
            int columnPos = this.findNodeInSection(tableRow, tableCell, "covered-table-cell");
            if (columnPos == -1) {
                LOGGER.warning("Table-Cell is not a direct child of the table-row. Unable to calculate the image-size.");
                return null;
            }
            LayoutController tableController = rowController.getParent();
            if (tableController == null) {
                LOGGER.warning("Table-Row has no Table. Unable to calculate the image-size.");
                return null;
            }
            Section table = (Section)tableController.getNode();
            Section columns = (Section)table.findFirstChild("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table-columns");
            if (columns.getNodeCount() <= columnPos + colSpan) {
                LOGGER.warning("The Table's defined columns do not match the col-span or col-position. Unable to calculate the image-size.");
                return null;
            }
            ImageElementContext context = new ImageElementContext(colSpan, rowSpan);
            this.addColumnStyles(context, columns, columnPos, colSpan);
            int rowPos = this.findNodeInSection(table, tableRow, null);
            if (rowPos == -1) {
                LOGGER.warning("Table-Cell is not a direct child of the table-row. Unable to calculate the image-size.");
                return null;
            }
            this.addRowStyles(context, table, rowPos, rowSpan);
            this.context = context;
        }
        return this.context;
    }

    private int findNodeInSection(Section tableRow, Element tableCell, String secondType) {
        int retval = 0;
        Node[] nodes = tableRow.getNodeArray();
        String namespace = tableCell.getNamespace();
        String type = tableCell.getType();
        for (Node node : nodes) {
            Element child;
            if (!(node instanceof Element) || !ObjectUtilities.equal((child = (Element)node).getNamespace(), namespace) || !ObjectUtilities.equal(child.getType(), type) && (secondType == null || !ObjectUtilities.equal(child.getType(), secondType))) continue;
            if (node == tableCell) {
                return retval;
            }
            ++retval;
        }
        return -1;
    }

    private LayoutController findParentCell() {
        for (LayoutController parent = this.getParent(); parent != null; parent = parent.getParent()) {
            Element element;
            Object node = parent.getNode();
            if (!(node instanceof Element) || !"urn:oasis:names:tc:opendocument:xmlns:table:1.0".equals((element = (Element)node).getNamespace()) || !"table-cell".equals(element.getType())) continue;
            return parent;
        }
        return null;
    }

    @Override
    public boolean isValueChanged() {
        ImageElement imageElement = (ImageElement)this.getNode();
        FormulaExpression formulaExpression = imageElement.getFormula();
        if (formulaExpression == null) {
            FlowController controller = this.getFlowController();
            GlobalMasterRow masterRow = controller.getMasterRow();
            ReportDataRow reportDataRow = masterRow.getReportDataRow();
            return reportDataRow.getCursor() == 0;
        }
        try {
            Formula formula = formulaExpression.getCompiledFormula();
            LValue lValue = formula.getRootReference();
            return FormatValueUtility.isReferenceChanged(this, lValue);
        }
        catch (ParseException e) {
            return false;
        }
    }

    void addColumnStyles(ImageElementContext context, Section columns, int columnPos, int colSpan) {
        Node[] columnDefs = columns.getNodeArray();
        int columnCounter = 0;
        for (Node columnDef : columnDefs) {
            Element column = (Element)columnDef;
            if (!ObjectUtilities.equal(column.getNamespace(), "urn:oasis:names:tc:opendocument:xmlns:table:1.0") || !ObjectUtilities.equal(column.getType(), "table-column")) continue;
            if (columnCounter >= columnPos) {
                String colStyle = (String)column.getAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
                context.setColStyle(columnCounter - columnPos, colStyle);
            }
            if (++columnCounter >= columnPos + colSpan) break;
        }
    }

    void addRowStyles(ImageElementContext context, Section table, int rowPos, int rowSpan) {
        Node[] rows = table.getNodeArray();
        int rowCounter = 0;
        for (Node row1 : rows) {
            Element row = (Element)row1;
            if (!ObjectUtilities.equal(row.getNamespace(), "urn:oasis:names:tc:opendocument:xmlns:table:1.0") || !ObjectUtilities.equal(row.getType(), "table-row")) continue;
            if (rowCounter >= rowPos) {
                String rowStyle = (String)row.getAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
                context.setRowStyle(rowCounter - rowPos, rowStyle);
            }
            if (++rowCounter >= rowPos + rowSpan) break;
        }
    }
}

