/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.output;

import com.sun.star.awt.Size;
import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.libreoffice.report.ImageService;
import org.libreoffice.report.InputRepository;
import org.libreoffice.report.OutputRepository;
import org.libreoffice.report.ReportExecutionException;
import org.libreoffice.report.pentaho.DefaultNameGenerator;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.PngEncoder;
import org.pentaho.reporting.libraries.base.util.WaitingImageObserver;

public class ImageProducer {
    private static final Logger LOGGER = Logger.getLogger(ImageProducer.class.getName());
    private final Map<Object, OfficeImage> imageCache;
    private final InputRepository inputRepository;
    private final OutputRepository outputRepository;
    private final ImageService imageService;

    public ImageProducer(InputRepository inputRepository, OutputRepository outputRepository, ImageService imageService) {
        if (inputRepository == null) {
            throw new NullPointerException();
        }
        if (outputRepository == null) {
            throw new NullPointerException();
        }
        if (imageService == null) {
            throw new NullPointerException();
        }
        this.inputRepository = inputRepository;
        this.outputRepository = outputRepository;
        this.imageService = imageService;
        this.imageCache = new HashMap<Object, OfficeImage>();
    }

    public OfficeImage produceImage(Object imageData, boolean preserveIRI) {
        LOGGER.config("Want to produce image " + imageData);
        if (imageData instanceof String) {
            return this.produceFromString((String)imageData, preserveIRI);
        }
        if (imageData instanceof URL) {
            return this.produceFromURL((URL)imageData, preserveIRI);
        }
        if (imageData instanceof Blob) {
            return this.produceFromBlob((Blob)imageData);
        }
        if (imageData instanceof byte[]) {
            return this.produceFromByteArray((byte[])imageData);
        }
        if (imageData instanceof Image) {
            return this.produceFromImage((Image)imageData);
        }
        return null;
    }

    private OfficeImage produceFromImage(Image image) {
        WaitingImageObserver obs = new WaitingImageObserver(image);
        obs.waitImageLoaded();
        PngEncoder encoder = new PngEncoder(image, true, 0, 5);
        byte[] data = encoder.pngEncode();
        return this.produceFromByteArray(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OfficeImage produceFromBlob(Blob blob) {
        try {
            InputStream inputStream = blob.getBinaryStream();
            int length = (int)blob.length();
            ByteArrayOutputStream bout = new ByteArrayOutputStream(length);
            try {
                IOUtils.getInstance().copyStreams(inputStream, bout);
            }
            finally {
                inputStream.close();
            }
            return this.produceFromByteArray(bout.toByteArray());
        }
        catch (IOException e) {
            LOGGER.warning("Failed to produce image from Blob: " + e);
        }
        catch (SQLException e) {
            LOGGER.warning("Failed to produce image from Blob: " + e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OfficeImage produceFromByteArray(byte[] data) {
        ByteDataImageKey imageKey = new ByteDataImageKey(data);
        OfficeImage o = this.imageCache.get(imageKey);
        if (o != null) {
            return o;
        }
        try {
            String mimeType = this.imageService.getMimeType(data);
            Size dims = this.imageService.getImageSize(data);
            OutputRepository storage = this.outputRepository.openOutputRepository("Pictures", null);
            DefaultNameGenerator nameGenerator = new DefaultNameGenerator(storage);
            String name = nameGenerator.generateName("image", mimeType);
            OutputStream outputStream = storage.createOutputStream(name, mimeType);
            ByteArrayInputStream bin = new ByteArrayInputStream(data);
            try {
                IOUtils.getInstance().copyStreams(bin, outputStream);
            }
            finally {
                outputStream.close();
                storage.closeOutputRepository();
            }
            CSSNumericValue widthVal = CSSNumericValue.createValue((CSSNumericType)CSSNumericType.MM, (double)((double)dims.Width / 100.0));
            CSSNumericValue heightVal = CSSNumericValue.createValue((CSSNumericType)CSSNumericType.MM, (double)((double)dims.Height / 100.0));
            OfficeImage officeImage = new OfficeImage("Pictures/" + name, widthVal, heightVal);
            this.imageCache.put(imageKey, officeImage);
            return officeImage;
        }
        catch (IOException e) {
            LOGGER.warning("Failed to load image from local input-repository: " + e);
        }
        catch (ReportExecutionException e) {
            LOGGER.warning("Failed to create image from local input-repository: " + e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OfficeImage produceFromString(String source, boolean preserveIRI) {
        try {
            URL url = new URL(source);
            return this.produceFromURL(url, preserveIRI);
        }
        catch (MalformedURLException url) {
            OfficeImage o = this.imageCache.get(source);
            if (o != null) {
                return o;
            }
            if (this.inputRepository.isReadable(source)) {
                try {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream(8192);
                    try (InputStream inputStream = this.inputRepository.createInputStream(source);){
                        IOUtils.getInstance().copyStreams(inputStream, bout);
                    }
                    byte[] data = bout.toByteArray();
                    Size dims = this.imageService.getImageSize(data);
                    String mimeType = this.imageService.getMimeType(data);
                    CSSNumericValue widthVal = CSSNumericValue.createValue((CSSNumericType)CSSNumericType.MM, (double)((double)dims.Width / 100.0));
                    CSSNumericValue heightVal = CSSNumericValue.createValue((CSSNumericType)CSSNumericType.MM, (double)((double)dims.Height / 100.0));
                    String filename = this.copyToOutputRepository(mimeType, data);
                    OfficeImage officeImage = new OfficeImage(filename, widthVal, heightVal);
                    this.imageCache.put(source, officeImage);
                    return officeImage;
                }
                catch (IOException e) {
                    LOGGER.warning("Failed to load image from local input-repository: " + e);
                }
                catch (ReportExecutionException e) {
                    LOGGER.warning("Failed to create image from local input-repository: " + e);
                }
            } else {
                try {
                    URI rootURI = new URI(this.inputRepository.getRootURL());
                    URI uri = rootURI.resolve(source);
                    return this.produceFromURL(uri.toURL(), preserveIRI);
                }
                catch (URISyntaxException rootURI) {
                }
                catch (MalformedURLException rootURI) {
                    // empty catch block
                }
            }
            OfficeImage officeImage = new OfficeImage(source, null, null);
            this.imageCache.put(source, officeImage);
            return officeImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OfficeImage produceFromURL(URL url, boolean preserveIRI) {
        String urlString = url.toString();
        URI uri = null;
        try {
            uri = new URI(urlString);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(ImageProducer.class.getName()).log(Level.SEVERE, null, ex);
        }
        OfficeImage o = this.imageCache.get(uri);
        if (o != null) {
            return o;
        }
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(8192);
            URLConnection urlConnection = url.openConnection();
            try (BufferedInputStream inputStream = new BufferedInputStream(urlConnection.getInputStream());){
                IOUtils.getInstance().copyStreams(inputStream, bout);
            }
            byte[] data = bout.toByteArray();
            Size dims = this.imageService.getImageSize(data);
            String mimeType = this.imageService.getMimeType(data);
            CSSNumericValue widthVal = CSSNumericValue.createValue((CSSNumericType)CSSNumericType.MM, (double)((double)dims.Width / 100.0));
            CSSNumericValue heightVal = CSSNumericValue.createValue((CSSNumericType)CSSNumericType.MM, (double)((double)dims.Height / 100.0));
            if (preserveIRI) {
                OfficeImage retval = new OfficeImage(urlString, widthVal, heightVal);
                this.imageCache.put(uri, retval);
                return retval;
            }
            String name = this.copyToOutputRepository(mimeType, data);
            OfficeImage officeImage = new OfficeImage(name, widthVal, heightVal);
            this.imageCache.put(uri, officeImage);
            return officeImage;
        }
        catch (IOException e) {
            LOGGER.warning("Failed to load image from local input-repository: " + e);
        }
        catch (ReportExecutionException e) {
            LOGGER.warning("Failed to create image from local input-repository: " + e);
        }
        if (!preserveIRI) {
            OfficeImage image = new OfficeImage(urlString, null, null);
            this.imageCache.put(uri, image);
            return image;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String copyToOutputRepository(String urlMimeType, byte[] data) throws IOException, ReportExecutionException {
        String mimeType = urlMimeType == null ? this.imageService.getMimeType(data) : urlMimeType;
        OutputRepository storage = this.outputRepository.openOutputRepository("Pictures", null);
        DefaultNameGenerator nameGenerator = new DefaultNameGenerator(storage);
        String name = nameGenerator.generateName("image", mimeType);
        OutputStream outputStream = storage.createOutputStream(name, mimeType);
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        try {
            IOUtils.getInstance().copyStreams(bin, outputStream);
        }
        finally {
            outputStream.close();
            storage.closeOutputRepository();
        }
        return "Pictures/" + name;
    }

    public static class OfficeImage {
        private final CSSNumericValue width;
        private final CSSNumericValue height;
        private final String embeddableLink;

        private OfficeImage(String embeddableLink, CSSNumericValue width, CSSNumericValue height) {
            this.embeddableLink = embeddableLink;
            this.width = width;
            this.height = height;
        }

        public CSSNumericValue getWidth() {
            return this.width;
        }

        public CSSNumericValue getHeight() {
            return this.height;
        }

        public String getEmbeddableLink() {
            return this.embeddableLink;
        }
    }

    private static class ByteDataImageKey {
        private final byte[] keyData;
        private Integer hashCode;

        protected ByteDataImageKey(byte[] keyData) {
            if (keyData == null) {
                throw new NullPointerException();
            }
            this.keyData = keyData;
        }

        public boolean equals(Object o) {
            if (this != o) {
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ByteDataImageKey key = (ByteDataImageKey)o;
                if (!Arrays.equals(this.keyData, key.keyData)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            if (this.hashCode != null) {
                return this.hashCode;
            }
            int length = Math.min(this.keyData.length, 512);
            int hashValue = 0;
            for (int i = 0; i < length; ++i) {
                byte b = this.keyData[i];
                hashValue = b + hashValue * 23;
            }
            this.hashCode = hashValue;
            return hashValue;
        }
    }
}

