/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.output.spreadsheet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.DataFlags;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.flow.ReportStructureRoot;
import org.jfree.report.flow.ReportTargetUtil;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Section;
import org.jfree.report.util.IntegerCache;
import org.libreoffice.report.DataSourceFactory;
import org.libreoffice.report.ImageService;
import org.libreoffice.report.InputRepository;
import org.libreoffice.report.OutputRepository;
import org.libreoffice.report.pentaho.model.OfficeMasterPage;
import org.libreoffice.report.pentaho.model.OfficeMasterStyles;
import org.libreoffice.report.pentaho.model.OfficeStyle;
import org.libreoffice.report.pentaho.model.OfficeStyles;
import org.libreoffice.report.pentaho.model.OfficeStylesCollection;
import org.libreoffice.report.pentaho.model.PageSection;
import org.libreoffice.report.pentaho.output.OfficeDocumentReportTarget;
import org.libreoffice.report.pentaho.output.StyleUtilities;
import org.libreoffice.report.pentaho.output.text.MasterPageFactory;
import org.libreoffice.report.pentaho.styles.LengthCalculator;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class SpreadsheetRawReportTarget
extends OfficeDocumentReportTarget {
    private static final String[] FOPROPS = new String[]{"letter-spacing", "font-variant", "text-transform"};
    private static final String NUMBERCOLUMNSSPANNED = "number-columns-spanned";
    private static final String[] STYLEPROPS = new String[]{"text-combine", "font-pitch-complex", "text-rotation-angle", "font-name", "text-blinking", "letter-kerning", "text-combine-start-char", "text-combine-end-char", "text-position", "text-scale"};
    private static final int CELL_WIDTH_FACTOR = 10000;
    private static final String TRANSPARENT = "transparent";
    private boolean paragraphFound = false;
    private boolean paragraphHandled = false;
    private String tableBackgroundColor;
    private boolean elementBoundaryCollectionPass = true;
    private boolean oleHandled = false;
    private final List<ColumnBoundary> columnBoundaryList = new ArrayList<ColumnBoundary>();
    private long currentRowBoundaryMarker;
    private ColumnBoundary[] sortedBoundaryArray;
    private ColumnBoundary[] boundariesForTableArray;
    private int tableCounter;
    private int columnCounter;
    private int columnSpanCounter;
    private int currentSpan = 0;
    private String unitsOfMeasure;
    private final List<AttributeMap> shapes;
    private final List<AttributeMap> ole;
    private final List<CSSNumericValue> rowHeights = new ArrayList<CSSNumericValue>();

    public SpreadsheetRawReportTarget(ReportJob reportJob, ResourceManager resourceManager, ResourceKey baseResource, InputRepository inputRepository, OutputRepository outputRepository, String target, ImageService imageService, DataSourceFactory dataSourceFactory) throws ReportProcessingException {
        super(reportJob, resourceManager, baseResource, inputRepository, outputRepository, target, imageService, dataSourceFactory);
        this.shapes = new ArrayList<AttributeMap>();
        this.ole = new ArrayList<AttributeMap>();
    }

    @Override
    public void startOther(AttributeMap attrs) throws DataSourceException, ReportProcessingException {
        if (ReportTargetUtil.isElementOfType("http://jfreereport.sourceforge.net/namespaces/engine", "object-ole", attrs)) {
            if (this.isElementBoundaryCollectionPass() && this.getCurrentRole() != 11) {
                this.ole.add(attrs);
            }
            this.oleHandled = true;
            return;
        }
        String namespace = ReportTargetUtil.getNamespaceFromAttribute(attrs);
        if (this.isRepeatingSection() || this.isFilteredNamespace(namespace)) {
            return;
        }
        String elementType = ReportTargetUtil.getElemenTypeFromAttribute(attrs);
        if ("urn:oasis:names:tc:opendocument:xmlns:text:1.0".equals(namespace) && "p".equals(elementType) && !this.paragraphHandled) {
            this.paragraphFound = true;
            return;
        }
        if ("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0".equals(namespace) && "frame".equals(elementType)) {
            if (this.isElementBoundaryCollectionPass() && this.getCurrentRole() != 11) {
                LengthCalculator len = new LengthCalculator();
                for (int i = 0; i < this.rowHeights.size(); ++i) {
                    len.add(this.rowHeights.get(i));
                }
                this.rowHeights.clear();
                CSSNumericValue currentRowHeight = len.getResult();
                this.rowHeights.add(currentRowHeight);
                attrs.setAttribute("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "z-index", (Object)String.valueOf(this.shapes.size()));
                String y = (String)attrs.getAttribute("urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "y");
                if (y != null) {
                    len.add(this.parseLength(y));
                    CSSNumericValue currentY = len.getResult();
                    attrs.setAttribute("urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "y", (Object)(currentY.getValue() + currentY.getType().getType()));
                }
                this.shapes.add(attrs);
            }
            return;
        }
        if (this.oleHandled) {
            if (this.isElementBoundaryCollectionPass() && this.getCurrentRole() != 11) {
                this.ole.add(attrs);
            }
            return;
        }
        if ("urn:oasis:names:tc:opendocument:xmlns:table:1.0".equals(namespace) && "table".equals(elementType)) {
            ++this.tableCounter;
        }
        if (this.isElementBoundaryCollectionPass()) {
            this.collectBoundaryForElement(attrs);
        } else {
            try {
                this.processElement(attrs, namespace, elementType);
            }
            catch (IOException e) {
                throw new ReportProcessingException("Failed", e);
            }
        }
    }

    @Override
    protected void startReportSection(AttributeMap attrs, int role) throws ReportProcessingException {
        if (!(role != 12 && role != 13 || PageSection.isPrintWithReportHeader(attrs) && PageSection.isPrintWithReportFooter(attrs))) {
            this.startBuffering(new OfficeStylesCollection(), true);
        } else {
            super.startReportSection(attrs, role);
        }
    }

    @Override
    protected void endReportSection(AttributeMap attrs, int role) throws IOException, ReportProcessingException {
        if (!(role != 12 && role != 13 || PageSection.isPrintWithReportHeader(attrs) && PageSection.isPrintWithReportFooter(attrs))) {
            this.finishBuffering();
        } else {
            super.endReportSection(attrs, role);
        }
    }

    private void handleParagraph() {
        if (this.paragraphFound) {
            try {
                XmlWriter xmlWriter = this.getXmlWriter();
                xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "p", null, false);
                this.paragraphHandled = true;
                this.paragraphFound = false;
            }
            catch (IOException ex) {
                LOGGER.severe("ReportProcessing failed: " + ex);
            }
        }
    }

    private void processElement(AttributeMap attrs, String namespace, String elementType) throws IOException, ReportProcessingException {
        String styleName;
        XmlWriter xmlWriter = this.getXmlWriter();
        if (ReportTargetUtil.isElementOfType("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table", attrs)) {
            String raw;
            this.boundariesForTableArray = null;
            String tableStyle = (String)attrs.getAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
            this.tableBackgroundColor = tableStyle == null ? null : ((raw = StyleUtilities.queryStyle(this.getPredefinedStylesCollection(), "table", tableStyle, "table-properties", "urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "background-color")) == null || TRANSPARENT.equals(raw) ? null : String.valueOf(raw));
            return;
        }
        if (ReportTargetUtil.isElementOfType("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table-column", attrs) || ReportTargetUtil.isElementOfType("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table-columns", attrs)) {
            return;
        }
        if (ReportTargetUtil.isElementOfType("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "covered-table-cell", attrs)) {
            if (this.columnSpanCounter > 0) {
                --this.columnSpanCounter;
            }
            if (this.columnSpanCounter == 0) {
                ++this.columnCounter;
                int span = this.getColumnSpanForCell(this.tableCounter, this.columnCounter, 1);
                for (int i = 0; i < span; ++i) {
                    xmlWriter.writeTag(namespace, "covered-table-cell", null, true);
                }
            }
            return;
        }
        if (ReportTargetUtil.isElementOfType("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table-row", attrs)) {
            this.columnCounter = 0;
            if (this.tableBackgroundColor != null) {
                styleName = (String)attrs.getAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
                OfficeStyle style = this.deriveStyle("table-row", styleName);
                Element tableRowProperties = style.getTableRowProperties();
                if (tableRowProperties == null) {
                    tableRowProperties = new Section();
                    tableRowProperties.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
                    tableRowProperties.setType("table-row-properties");
                    tableRowProperties.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "background-color", this.tableBackgroundColor);
                    style.addNode(tableRowProperties);
                } else {
                    Object oldValue = tableRowProperties.getAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "background-color");
                    if (oldValue == null || TRANSPARENT.equals(oldValue)) {
                        tableRowProperties.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "background-color", this.tableBackgroundColor);
                    }
                }
                attrs.setAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name", (Object)style.getStyleName());
            }
        } else if (ReportTargetUtil.isElementOfType("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table-cell", attrs)) {
            ++this.columnCounter;
            styleName = (String)attrs.getAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
            if (styleName != null) {
                OfficeStyle cellStyle = this.getPredefinedStylesCollection().getStyle("table-cell", styleName);
                if (cellStyle != null) {
                    Object raw;
                    Section props;
                    Section textProperties = (Section)cellStyle.getTextProperties();
                    if (textProperties != null) {
                        for (String i : FOPROPS) {
                            textProperties.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", i, null);
                        }
                        textProperties.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "display", null);
                        for (String i : STYLEPROPS) {
                            textProperties.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", i, null);
                        }
                    }
                    if ((props = (Section)cellStyle.getTableCellProperties()) != null && TRANSPARENT.equals(raw = props.getAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "background-color"))) {
                        props.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "background-color", null);
                    }
                }
                attrs.setAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name", (Object)styleName);
            }
            String numColSpanStr = (String)attrs.getAttribute(namespace, NUMBERCOLUMNSSPANNED);
            this.columnSpanCounter = 1;
            int initialColumnSpan = 1;
            if (numColSpanStr != null) {
                this.columnSpanCounter = initialColumnSpan = Integer.parseInt(numColSpanStr);
            }
            int span = this.getColumnSpanForCell(this.tableCounter, this.columnCounter, initialColumnSpan);
            if (initialColumnSpan > 1) {
                this.columnCounter += initialColumnSpan - 1;
            }
            if (span > 1) {
                attrs.setAttribute(namespace, NUMBERCOLUMNSSPANNED, (Object)("" + span));
                this.currentSpan = span;
            }
        }
        this.performStyleProcessing(attrs);
        AttributeList attrList = this.buildAttributeList(attrs);
        xmlWriter.writeTag(namespace, elementType, attrList, false);
    }

    private void collectBoundaryForElement(AttributeMap attrs) {
        if (ReportTargetUtil.isElementOfType("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table-columns", attrs)) {
            this.resetCurrentRowBoundaryMarker();
        } else if (ReportTargetUtil.isElementOfType("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table-column", attrs)) {
            String styleName = (String)attrs.getAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
            if (styleName == null) {
                return;
            }
            OfficeStyle style = this.getPredefinedStylesCollection().getStyle("table-column", styleName);
            if (style == null) {
                return;
            }
            Element tableColumnProperties = style.getTableColumnProperties();
            String widthStr = (String)tableColumnProperties.getAttribute("column-width");
            widthStr = widthStr.substring(0, widthStr.indexOf(this.getUnitsOfMeasure(widthStr)));
            float val = Float.parseFloat(widthStr) * 10000.0f;
            this.addColumnWidthToRowBoundaryMarker((long)val);
            ColumnBoundary currentRowBoundary = new ColumnBoundary(this.getCurrentRowBoundaryMarker());
            List<ColumnBoundary> columnBoundaryList_ = this.getColumnBoundaryList();
            int idx = columnBoundaryList_.indexOf(currentRowBoundary);
            if (idx == -1) {
                columnBoundaryList_.add(currentRowBoundary);
            } else {
                currentRowBoundary = columnBoundaryList_.get(idx);
            }
            currentRowBoundary.addTableIndex(this.tableCounter);
        }
    }

    private String getUnitsOfMeasure(String str) {
        if (this.unitsOfMeasure == null || "".equals(this.unitsOfMeasure)) {
            char c;
            int i;
            if (str == null || "".equals(str)) {
                this.unitsOfMeasure = "cm";
                return this.unitsOfMeasure;
            }
            for (i = str.length() - 1; i >= 0 && !Character.isDigit(c = str.charAt(i)) && c != '.' && c != ','; --i) {
            }
            this.unitsOfMeasure = str.substring(i + 1);
        }
        return this.unitsOfMeasure;
    }

    private void createTableShapes() throws ReportProcessingException {
        if (!this.shapes.isEmpty()) {
            try {
                XmlWriter xmlWriter = this.getXmlWriter();
                xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "shapes", null, false);
                for (int i = 0; i < this.shapes.size(); ++i) {
                    AttributeMap attrs = this.shapes.get(i);
                    AttributeList attrList = this.buildAttributeList(attrs);
                    attrList.removeAttribute("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "style-name");
                    xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "frame", attrList, false);
                    this.startChartProcessing(this.ole.get(i));
                    xmlWriter.writeCloseTag();
                }
                xmlWriter.writeCloseTag();
            }
            catch (IOException e) {
                throw new ReportProcessingException("Failed", e);
            }
        }
    }

    private void createTableColumns() throws ReportProcessingException {
        try {
            XmlWriter xmlWriter = this.getXmlWriter();
            xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table-columns", null, false);
            ColumnBoundary[] cba = this.getSortedColumnBoundaryArray();
            for (int i = 1; i < cba.length; ++i) {
                ColumnBoundary cb = cba[i];
                float columnWidth = cb.getBoundary();
                if (i > 1) {
                    columnWidth -= cba[i - 1].getBoundary();
                }
                OfficeStyle style = this.deriveStyle("table-column", "co" + i + "_");
                Section tableColumnProperties = new Section();
                tableColumnProperties.setType("table-column-properties");
                tableColumnProperties.setNamespace(style.getNamespace());
                String width = String.format("%f", Float.valueOf(columnWidth /= 10000.0f));
                tableColumnProperties.setAttribute(style.getNamespace(), "column-width", width + this.getUnitsOfMeasure(null));
                style.addNode(tableColumnProperties);
                AttributeList myAttrList = new AttributeList();
                myAttrList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name", style.getStyleName());
                xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table-column", myAttrList, true);
            }
            xmlWriter.writeCloseTag();
        }
        catch (IOException e) {
            throw new ReportProcessingException("Failed", e);
        }
    }

    @Override
    protected void endOther(AttributeMap attrs) throws DataSourceException, ReportProcessingException {
        if (ReportTargetUtil.isElementOfType("http://jfreereport.sourceforge.net/namespaces/engine", "object-ole", attrs) || this.oleHandled) {
            this.oleHandled = false;
            return;
        }
        if (ReportTargetUtil.isElementOfType("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table-row", attrs) && this.isElementBoundaryCollectionPass() && this.getCurrentRole() != 11) {
            String styleName = (String)attrs.getAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
            this.rowHeights.add(this.computeRowHeight(styleName));
        }
        if (this.isRepeatingSection() || this.isElementBoundaryCollectionPass()) {
            return;
        }
        String namespace = ReportTargetUtil.getNamespaceFromAttribute(attrs);
        if (this.isFilteredNamespace(namespace)) {
            return;
        }
        String elementType = ReportTargetUtil.getElemenTypeFromAttribute(attrs);
        if ("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0".equals(namespace) && "frame".equals(elementType)) {
            return;
        }
        if ("urn:oasis:names:tc:opendocument:xmlns:table:1.0".equals(namespace) && ("table".equals(elementType) || "covered-table-cell".equals(elementType) || "table-column".equals(elementType) || "table-columns".equals(elementType))) {
            return;
        }
        if (!this.paragraphHandled && "urn:oasis:names:tc:opendocument:xmlns:text:1.0".equals(namespace) && "p".equals(elementType)) {
            if (!this.paragraphHandled) {
                return;
            }
            this.paragraphHandled = false;
        }
        try {
            XmlWriter xmlWriter = this.getXmlWriter();
            xmlWriter.writeCloseTag();
            this.generateCoveredTableCells(attrs);
        }
        catch (IOException e) {
            throw new ReportProcessingException("Failed", e);
        }
    }

    private void generateCoveredTableCells(AttributeMap attrs) throws IOException {
        if (!ReportTargetUtil.isElementOfType("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table-cell", attrs)) {
            return;
        }
        XmlWriter xmlWriter = this.getXmlWriter();
        int span = this.currentSpan;
        this.currentSpan = 0;
        for (int i = 1; i < span; ++i) {
            xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "covered-table-cell", null, true);
        }
    }

    @Override
    public String getExportDescriptor() {
        return "raw/application/vnd.oasis.opendocument.spreadsheet";
    }

    @Override
    public void processText(String text) throws DataSourceException, ReportProcessingException {
        if (!this.isRepeatingSection() && !this.isElementBoundaryCollectionPass()) {
            this.handleParagraph();
            super.processText(text);
        }
    }

    @Override
    public void processContent(DataFlags value) throws DataSourceException, ReportProcessingException {
        if (!this.isRepeatingSection() && !this.isElementBoundaryCollectionPass()) {
            this.handleParagraph();
            super.processContent(value);
        }
    }

    private String getStartContent() {
        return "spreadsheet";
    }

    @Override
    protected void startContent(AttributeMap attrs) throws IOException, DataSourceException, ReportProcessingException {
        if (!this.isElementBoundaryCollectionPass()) {
            XmlWriter xmlWriter = this.getXmlWriter();
            xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:office:1.0", this.getStartContent(), null, false);
            this.writeNullDate();
            AttributeMap tableAttributes = new AttributeMap();
            tableAttributes.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "namespace", (Object)"urn:oasis:names:tc:opendocument:xmlns:table:1.0");
            tableAttributes.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "type", (Object)"table");
            tableAttributes.setAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name", (Object)this.generateInitialTableStyle());
            tableAttributes.setAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "name", (Object)"Report");
            this.performStyleProcessing(tableAttributes);
            xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table", this.buildAttributeList(tableAttributes), false);
            this.createTableShapes();
            this.createTableColumns();
        }
    }

    private String generateInitialTableStyle() throws ReportProcessingException {
        OfficeStylesCollection predefStyles = this.getPredefinedStylesCollection();
        OfficeStyles commonStyles = predefStyles.getAutomaticStyles();
        if (!commonStyles.containsStyle("table", "Initial_Table")) {
            String masterPageName = this.createMasterPage();
            OfficeStyle tableStyle = new OfficeStyle();
            tableStyle.setStyleFamily("table");
            tableStyle.setStyleName("Initial_Table");
            tableStyle.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "master-page-name", masterPageName);
            Element tableProperties = this.produceFirstChild(tableStyle, "urn:oasis:names:tc:opendocument:xmlns:style:1.0", "table-properties");
            tableProperties.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "background-color", TRANSPARENT);
            commonStyles.addStyle(tableStyle);
        }
        return "Initial_Table";
    }

    private String createMasterPage() throws ReportProcessingException {
        OfficeMasterPage masterPage;
        OfficeStylesCollection predefStyles = this.getPredefinedStylesCollection();
        MasterPageFactory masterPageFactory = new MasterPageFactory(predefStyles.getMasterStyles());
        if (!masterPageFactory.containsMasterPage("Standard", null, null)) {
            String derivedLayout;
            masterPage = masterPageFactory.createMasterPage("Standard", null, null);
            CSSNumericValue zeroLength = CSSNumericValue.createValue((CSSNumericType)CSSNumericType.CM, (double)0.0);
            String pageLayoutTemplate = masterPage.getPageLayout();
            if (pageLayoutTemplate == null) {
                derivedLayout = masterPageFactory.createPageStyle(this.getGlobalStylesCollection().getAutomaticStyles(), zeroLength, zeroLength);
                masterPage.setPageLayout(derivedLayout);
            } else {
                derivedLayout = masterPageFactory.derivePageStyle(pageLayoutTemplate, this.getPredefinedStylesCollection().getAutomaticStyles(), this.getGlobalStylesCollection().getAutomaticStyles(), zeroLength, zeroLength);
                masterPage.setPageLayout(derivedLayout);
            }
            OfficeStylesCollection officeStylesCollection = this.getGlobalStylesCollection();
            OfficeMasterStyles officeMasterStyles = officeStylesCollection.getMasterStyles();
            officeMasterStyles.addMasterPage(masterPage);
        } else {
            masterPage = masterPageFactory.getMasterPage("Standard", null, null);
        }
        return masterPage.getStyleName();
    }

    @Override
    protected void endContent(AttributeMap attrs) throws IOException, DataSourceException, ReportProcessingException {
        if (!this.isElementBoundaryCollectionPass()) {
            XmlWriter xmlWriter = this.getXmlWriter();
            xmlWriter.writeCloseTag();
            xmlWriter.writeCloseTag();
        }
    }

    @Override
    public void endReport(ReportStructureRoot report) throws DataSourceException, ReportProcessingException {
        super.endReport(report);
        this.setElementBoundaryCollectionPass(false);
        this.resetTableCounter();
        this.columnCounter = 0;
        this.copyMeta();
    }

    private boolean isElementBoundaryCollectionPass() {
        return this.elementBoundaryCollectionPass;
    }

    private void setElementBoundaryCollectionPass(boolean elementBoundaryCollectionPass) {
        this.elementBoundaryCollectionPass = elementBoundaryCollectionPass;
    }

    private ColumnBoundary[] getSortedColumnBoundaryArray() {
        if (this.sortedBoundaryArray == null) {
            this.getColumnBoundaryList().add(new ColumnBoundary(0L));
            this.sortedBoundaryArray = this.getColumnBoundaryList().toArray(new ColumnBoundary[this.getColumnBoundaryList().size()]);
            Arrays.sort(this.sortedBoundaryArray);
        }
        return this.sortedBoundaryArray;
    }

    private List<ColumnBoundary> getColumnBoundaryList() {
        return this.columnBoundaryList;
    }

    private void addColumnWidthToRowBoundaryMarker(long width) {
        this.currentRowBoundaryMarker += width;
    }

    private long getCurrentRowBoundaryMarker() {
        return this.currentRowBoundaryMarker;
    }

    private void resetTableCounter() {
        this.tableCounter = 0;
    }

    private void resetCurrentRowBoundaryMarker() {
        this.currentRowBoundaryMarker = 0L;
    }

    private ColumnBoundary[] getBoundariesForTable(int table) {
        if (this.boundariesForTableArray == null) {
            ArrayList<ColumnBoundary> boundariesForTable = new ArrayList<ColumnBoundary>();
            List<ColumnBoundary> boundaryList = this.getColumnBoundaryList();
            for (int i = 0; i < boundaryList.size(); ++i) {
                ColumnBoundary b = boundaryList.get(i);
                if (!b.isContainedByTable(table)) continue;
                boundariesForTable.add(b);
            }
            this.boundariesForTableArray = boundariesForTable.toArray(new ColumnBoundary[boundariesForTable.size()]);
            Arrays.sort(this.boundariesForTableArray);
        }
        return this.boundariesForTableArray;
    }

    private int getColumnSpanForCell(int table, int col, int initialColumnSpan) {
        ColumnBoundary[] globalBoundaries = this.getSortedColumnBoundaryArray();
        ColumnBoundary[] tableBoundaries = this.getBoundariesForTable(table);
        float cellBoundary = tableBoundaries[col - 1].getBoundary();
        float cellWidth = tableBoundaries[col - 1].getBoundary();
        if (col > 1) {
            cellWidth -= tableBoundaries[col - 2].getBoundary();
        }
        if (initialColumnSpan > 1) {
            int index = col - 1 + (initialColumnSpan - 1);
            cellWidth += tableBoundaries[index].getBoundary() - tableBoundaries[col - 1].getBoundary();
            cellBoundary = tableBoundaries[index].getBoundary();
        }
        int beginBoundaryIndex = 0;
        int endBoundaryIndex = globalBoundaries.length - 1;
        for (int i = 0; i < globalBoundaries.length; ++i) {
            if (globalBoundaries[i].getBoundary() <= cellBoundary - cellWidth) {
                beginBoundaryIndex = i;
            }
            if (!(globalBoundaries[i].getBoundary() <= cellBoundary)) continue;
            endBoundaryIndex = i;
        }
        int span = endBoundaryIndex - beginBoundaryIndex;
        if (span == 0) {
            return 1;
        }
        return span;
    }

    @Override
    protected String getTargetMimeType() {
        return "application/vnd.oasis.opendocument.spreadsheet";
    }

    private static class ColumnBoundary
    implements Comparable<ColumnBoundary> {
        private final Set<Integer> tableIndices = new HashSet<Integer>();
        private final long boundary;

        private ColumnBoundary(long boundary) {
            this.boundary = boundary;
        }

        public void addTableIndex(int table) {
            this.tableIndices.add(IntegerCache.getInteger(table));
        }

        public float getBoundary() {
            return this.boundary;
        }

        public boolean isContainedByTable(int table) {
            Integer index = IntegerCache.getInteger(table);
            return this.tableIndices.contains(index);
        }

        @Override
        public int compareTo(ColumnBoundary arg0) {
            if (arg0.equals(this)) {
                return 0;
            }
            if (this.boundary > arg0.boundary) {
                return 1;
            }
            return -1;
        }

        public boolean equals(Object obj) {
            return obj instanceof ColumnBoundary && ((ColumnBoundary)obj).boundary == this.boundary;
        }

        public int hashCode() {
            assert (false) : "hashCode not designed";
            return 42;
        }
    }
}

