/*
 * Decompiled with CFR 0.152.
 */
package com.codelathe.tools;

import com.codelathe.tools.FCDocConverter;
import com.codelathe.tools.libreoffice.LibreOfficeAdapter;
import com.codelathe.tools.pdfbox.PDFBoxAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ConverterServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String THUMBFORMAT = "png";
    private static final String THUMBMIME = "image/png";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.checkSecurity(request, response)) {
            response.setStatus(401);
            response.getWriter().write("FC Docconverter access denied");
            return;
        }
        String op = "ping";
        if (request.getParameterMap().containsKey("op")) {
            op = request.getParameter("op");
        }
        if ("ping".equals(op)) {
            this.respondToPing(request, response);
        } else if ("getthumb".equals(op)) {
            this.convertPDFToImage(request, response);
        } else if ("converttopdf".equals(op)) {
            this.convertDocToPDF(request, response);
        } else if ("convertpdftoimages".equals(op)) {
            this.convertPDFToImages(request, response);
        } else {
            response.setStatus(400);
            response.getWriter().write("Unknown operation:" + op);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.checkSecurity(request, response)) {
            response.setStatus(401);
            response.getWriter().write("FC Docconverter access denied");
            return;
        }
        String op = "";
        if (request.getParameterMap().containsKey("op")) {
            op = request.getParameter("op");
        }
        if ("combinepdf".equals(op)) {
            this.combinePDFs(request, response);
        } else if ("watermarkpdf".equals(op)) {
            this.watermarkPDF(request, response);
        } else {
            response.setStatus(400);
            response.getWriter().write("Unknown operation:" + op);
        }
    }

    private boolean checkSecurity(HttpServletRequest request, HttpServletResponse response) {
        String incomingkey;
        return FCDocConverter.FCDOCCONVERTER_SECURITY_KEY == null || (incomingkey = request.getHeader("X-FCDOCCONVERTER-SECURITY-KEY")) != null && incomingkey.equals(FCDocConverter.FCDOCCONVERTER_SECURITY_KEY);
    }

    private void respondToPing(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pingResponse = "SERVEROK-V" + FCDocConverter.VERSION;
        pingResponse = String.valueOf(pingResponse) + "-|WATERMARK|";
        String[] a = ImageIO.getReaderFileSuffixes();
        int i = 0;
        while (i < a.length) {
            pingResponse = String.valueOf(pingResponse) + "-" + a[i];
            ++i;
        }
        response.setStatus(200);
        response.getWriter().write(pingResponse);
        response.getWriter().flush();
        response.getWriter().close();
    }

    private void convertPDFToImage(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String file = null;
        if (request.getParameterMap().containsKey("file")) {
            file = request.getParameter("file");
        } else {
            FCDocConverter.logger.severe("Missing file " + file);
        }
        String ext = "pdf";
        if (request.getParameterMap().containsKey("ext")) {
            ext = request.getParameter("ext");
        }
        int width = 128;
        if (request.getParameterMap().containsKey("width")) {
            try {
                width = Integer.parseInt(request.getParameter("width"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int height = 128;
        if (request.getParameterMap().containsKey("height")) {
            try {
                height = Integer.parseInt(request.getParameter("height"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        long startTime = System.nanoTime();
        BufferedImage image = PDFBoxAdapter.fileToThumb(file, ext, width, height);
        if (image == null) {
            FCDocConverter.logger.severe("Unable to convert file to image: " + file);
        }
        response.setContentType(THUMBMIME);
        ServletOutputStream out = response.getOutputStream();
        ImageIO.write((RenderedImage)image, THUMBFORMAT, (OutputStream)out);
        out.close();
        long endTime = System.nanoTime();
        long duration = endTime - startTime;
        FCDocConverter.logger.info("Converted " + file + " (" + width + "x+" + height + ") in " + duration / 1000000L + "ms");
    }

    private void convertDocToPDF(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String infile = null;
        PrintWriter outstream = response.getWriter();
        if (!request.getParameterMap().containsKey("infile")) {
            FCDocConverter.logger.severe("convertDocToPDF: Missing file " + infile);
            response.setStatus(400);
            outstream.println("PDF conversion failed");
            return;
        }
        infile = request.getParameter("infile");
        File inFile = new File(infile);
        if (!inFile.canRead()) {
            FCDocConverter.logger.severe("convertDocToPDF: Unable to read file " + infile + ". Check if converter has read permissions");
            response.setStatus(400);
            outstream.println("Unable to read file. PDF conversion failed");
            return;
        }
        String outfile = null;
        if (!request.getParameterMap().containsKey("outpdf")) {
            FCDocConverter.logger.severe("convertDocToPDF: Missing output pdf " + infile);
            response.setStatus(400);
            outstream.println("PDF conversion failed");
            return;
        }
        outfile = request.getParameter("outpdf");
        File outFile = new File(outfile);
        if (!outFile.canWrite()) {
            FCDocConverter.logger.severe("convertDocToPDF: Out file has no write permissions :" + outfile);
            response.setStatus(400);
            outstream.println("Unable to create preview. PDF conversion failed");
            return;
        }
        long startTime = System.nanoTime();
        FCDocConverter.logger.info("Converting " + infile + " to pdf");
        boolean success = LibreOfficeAdapter.convertFile(infile, outfile);
        if (!success) {
            FCDocConverter.logger.severe("Failed to convert file to pdf: " + infile);
            response.setStatus(500);
            outstream.println("PDF conversion failed");
        } else {
            long endTime = System.nanoTime();
            long duration = endTime - startTime;
            response.setStatus(200);
            outstream.println("PDF conversion success");
            FCDocConverter.logger.info("Converted " + infile + " in " + duration / 1000000L + "ms");
        }
    }

    private void watermarkPDF(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String infile = null;
        PrintWriter outstream = response.getWriter();
        if (!request.getParameterMap().containsKey("infile")) {
            FCDocConverter.logger.severe("watermarkPDF: Missing file " + infile);
            response.setStatus(400);
            outstream.println("Watermark failed");
            return;
        }
        infile = request.getParameter("infile");
        File inpdfFile = new File(infile);
        if (!inpdfFile.canRead()) {
            FCDocConverter.logger.severe("watermarkPDF: Unable to read file " + infile + ". Check if converter has read permissions");
            response.setStatus(400);
            outstream.println("Unable to read file. Watermark failed");
            return;
        }
        String outpdf = null;
        if (!request.getParameterMap().containsKey("outfile")) {
            FCDocConverter.logger.severe("convertDocToPDF: Missing output pdf " + outpdf);
            response.setStatus(400);
            outstream.println("PDF conversion failed");
            return;
        }
        outpdf = request.getParameter("outfile");
        File outFile = new File(outpdf);
        if (!outFile.canWrite()) {
            FCDocConverter.logger.severe("watermarkPDF: No write permissions :" + outpdf);
            response.setStatus(400);
            outstream.println("Unable to write to file. Watermark failed");
            return;
        }
        String watermark = null;
        if (!request.getParameterMap().containsKey("watermark")) {
            FCDocConverter.logger.severe("watermarkPDF: Missing watermark text");
            response.setStatus(400);
            outstream.println("Watermark failed");
            return;
        }
        watermark = request.getParameter("watermark");
        long startTime = System.nanoTime();
        FCDocConverter.logger.info("Adding watermark " + watermark);
        if (watermark != null) {
            FCDocConverter.logger.info("Adding watermark to the PDF");
            PDFBoxAdapter.watermarkPDF(infile, outpdf, watermark);
        }
        long endTime = System.nanoTime();
        long duration = endTime - startTime;
        response.setStatus(200);
        outstream.println("Watermark added successfully");
        FCDocConverter.logger.info("Watermark added to " + infile + " in " + duration / 1000000L + "ms");
    }

    private void combinePDFs(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int count = 0;
        PrintWriter outstream = response.getWriter();
        if (!request.getParameterMap().containsKey("count")) {
            FCDocConverter.logger.severe("combinePDFs: Missing number of files to combine");
            response.setStatus(400);
            outstream.println("PDF combine failed");
            return;
        }
        count = Integer.parseInt(request.getParameter("count"));
        if (count == 0) {
            FCDocConverter.logger.severe("combinePDFs: Zero files to combine");
            response.setStatus(400);
            outstream.println("PDF combine failed");
            return;
        }
        String[] infiles = new String[count];
        int i = 0;
        while (i < count) {
            String param = "infile" + i;
            if (!request.getParameterMap().containsKey(param)) {
                FCDocConverter.logger.severe("combinePDFs: Missing file path: " + param);
                response.setStatus(400);
                outstream.println("PDF combine failed");
                return;
            }
            infiles[i] = request.getParameter(param);
            ++i;
        }
        if (!request.getParameterMap().containsKey("outfile")) {
            FCDocConverter.logger.severe("combinePDFs: Missing output file path: ");
            response.setStatus(400);
            outstream.println("PDF combine failed");
            return;
        }
        String outfile = request.getParameter("outfile");
        long startTime = System.nanoTime();
        boolean success = PDFBoxAdapter.combinePDFs(infiles, outfile);
        if (!success) {
            FCDocConverter.logger.severe("Failed to combile pdfs");
            response.setStatus(500);
            outstream.println("PDF conversion failed");
        } else {
            long endTime = System.nanoTime();
            long duration = endTime - startTime;
            response.setStatus(200);
            outstream.println("PDF conversion success");
            FCDocConverter.logger.info("Combined " + count + " files in " + duration / 1000000L + "ms");
        }
    }

    private void convertPDFToImages(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String infile = null;
        PrintWriter outstream = response.getWriter();
        if (!request.getParameterMap().containsKey("infile")) {
            FCDocConverter.logger.severe("Missing file " + infile);
            response.setStatus(400);
            outstream.println("Missing infile parameter");
            return;
        }
        infile = request.getParameter("infile");
        String outfile = null;
        if (!request.getParameterMap().containsKey("outzip")) {
            FCDocConverter.logger.severe("convertPDFToImages: Missing output zip " + infile);
            response.setStatus(400);
            outstream.println("PDF to image conversion failed");
            return;
        }
        outfile = request.getParameter("outzip");
        File outFile = new File(outfile);
        if (!outFile.canWrite()) {
            FCDocConverter.logger.severe("convertPDFToImages: Out file has no write permissions :" + outfile);
            response.setStatus(400);
            outstream.println("Unable to create zip file. PDF to image conversion failed");
            return;
        }
        int width = 800;
        if (request.getParameterMap().containsKey("width")) {
            try {
                width = Integer.parseInt(request.getParameter("width"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int height = 600;
        if (request.getParameterMap().containsKey("height")) {
            try {
                height = Integer.parseInt(request.getParameter("height"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        long startTime = System.nanoTime();
        FileOutputStream fos = new FileOutputStream(outFile);
        boolean success = PDFBoxAdapter.pdfToImages(infile, width, height, fos);
        if (!success) {
            FCDocConverter.logger.severe("Unable to convert PDF file to images: " + infile);
            response.setStatus(400);
            outstream.println("ConvertPDFToImages: Unable to convert PDF file to images: " + infile);
            fos.close();
            return;
        }
        fos.close();
        long endTime = System.nanoTime();
        long duration = endTime - startTime;
        FCDocConverter.logger.info("Converted " + infile + " to images of size (" + width + "x+" + height + ") in " + duration / 1000000L + "ms");
    }
}

