/*
 * Decompiled with CFR 0.152.
 */
package com.codelathe.tools;

import com.codelathe.tools.ConverterServlet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class FCDocConverter {
    public static String VERSION = "20221110";
    public static Logger logger = null;
    private static Server server;
    public static String FCDOCCONVERTER_SECURITY_KEY;

    static {
        FCDOCCONVERTER_SECURITY_KEY = null;
    }

    public static void initializelogging() {
        Handler handler;
        Handler[] handlers;
        LogManager.getLogManager().reset();
        Logger globalLogger = Logger.getLogger("global");
        globalLogger.setLevel(Level.OFF);
        Handler[] handlerArray = handlers = globalLogger.getHandlers();
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            handler = handlerArray[n2];
            globalLogger.removeHandler(handler);
            ++n2;
        }
        logger = Logger.getLogger("fc.doc.converter.log");
        logger.setUseParentHandlers(false);
        handler = null;
        try {
            handler = new FileHandler("converter.log");
        }
        catch (IOException e) {
            System.out.println("Could not create file. Using the console handler");
            handler = new ConsoleHandler();
        }
        logger.addHandler(handler);
        handler.setFormatter(new SimpleFormatter());
    }

    public static void parseInitFile() {
        logger.info("Checking for ini file");
        File fcinifile = Paths.get("fcdocconverter.ini", new String[0]).toFile();
        if (fcinifile.exists() && fcinifile.canRead()) {
            logger.info("Found ini file");
            try {
                FileInputStream fcinistream = new FileInputStream(fcinifile);
                Properties properties = new Properties();
                properties.load(fcinistream);
                if (properties.getProperty("FCDOCCONVERTER_SECURITY_KEY") != null) {
                    logger.info("Found a security key in the ini. Will be check this key for all requests.");
                    FCDOCCONVERTER_SECURITY_KEY = properties.getProperty("FCDOCCONVERTER_SECURITY_KEY");
                }
            }
            catch (IOException e) {
                logger.info("Error reading ini file");
            }
        }
    }

    public static void start(String[] args) throws Exception {
        FCDocConverter.initializelogging();
        FCDocConverter.parseInitFile();
        FCDocConverter.startJettyServer(args);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/fcconverter");
        server.setHandler((org.eclipse.jetty.server.Handler)context);
        context.addServlet(new ServletHolder((Servlet)new ConverterServlet()), "/*");
        server.start();
        server.join();
    }

    public static void stop(String[] args) throws Exception {
        if (server != null && server.isRunning()) {
            server.stop();
            System.exit(0);
        }
    }

    private static void startJettyServer(String[] args) {
        int port = 8080;
        String host = "localhost";
        if (args.length >= 1) {
            try {
                port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (args.length == 2) {
            host = args[1];
        }
        if ("all".equals(host)) {
            server = new Server(port);
        } else {
            InetSocketAddress isa = new InetSocketAddress(host, port);
            server = new Server(isa);
        }
    }

    public static void main(String[] args) throws Exception {
        String cmd = "start";
        if ("start".equals(cmd)) {
            FCDocConverter.start(args);
        } else if ("stop".equals(cmd)) {
            FCDocConverter.stop(args);
        }
    }
}

