/*
 * Decompiled with CFR 0.152.
 */
package com.codelathe.tools.libreoffice;

import com.codelathe.tools.FCDocConverter;
import com.codelathe.tools.libreoffice.Bootstrap;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.XCloseable;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;

public class LibreOfficeAdapter {
    static XComponentLoader xCompLoader = null;
    static XComponentContext xContext = null;

    private LibreOfficeAdapter() {
    }

    public static boolean convertFile(String inFile, String outFile) throws IOException {
        String sinUrl = "file:///" + inFile.replace('\\', '/');
        String soutUrl = "file:///" + outFile.replace('\\', '/');
        if (!LibreOfficeAdapter.initialize()) {
            return false;
        }
        try {
            PropertyValue[] propertyValues = new PropertyValue[]{new PropertyValue()};
            propertyValues[0].Name = "Hidden";
            propertyValues[0].Value = Boolean.TRUE;
            XComponent oDocToStore = xCompLoader.loadComponentFromURL(sinUrl, "_blank", 0, propertyValues);
            XStorable xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)oDocToStore);
            propertyValues = new PropertyValue[2];
            propertyValues[0] = new PropertyValue();
            propertyValues[0].Name = "Overwrite";
            propertyValues[0].Value = Boolean.TRUE;
            propertyValues[1] = new PropertyValue();
            propertyValues[1].Name = "FilterName";
            propertyValues[1].Value = "writer_pdf_Export";
            xStorable.storeToURL(soutUrl, propertyValues);
            XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)xStorable);
            if (xCloseable != null) {
                xCloseable.close(false);
            } else {
                XComponent xComp = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xStorable);
                xComp.dispose();
            }
            return true;
        }
        catch (Exception e) {
            FCDocConverter.logger.log(Level.SEVERE, "Error", e);
            xContext = null;
            return false;
        }
    }

    private static boolean initialize() {
        if (xContext != null) {
            return true;
        }
        try {
            String[] libpaths = System.getProperty("java.library.path").split(File.pathSeparator);
            String oopath = "";
            if (libpaths.length > 0) {
                int i = 0;
                while (i < libpaths.length) {
                    if (libpaths[i].toLowerCase().contains("libreoffice")) {
                        oopath = libpaths[i];
                        break;
                    }
                    ++i;
                }
            }
            FCDocConverter.logger.info("Bootstrapping with libre path: " + oopath);
            xContext = Bootstrap.bootstrap(oopath);
            FCDocConverter.logger.info("Connected to a running office ...");
            XMultiComponentFactory xMCF = xContext.getServiceManager();
            Object oDesktop = xMCF.createInstanceWithContext("com.sun.star.frame.Desktop", xContext);
            xCompLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)oDesktop);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            FCDocConverter.logger.severe("Native code library failed to load.");
            FCDocConverter.logger.log(Level.SEVERE, "Error", e);
        }
        catch (Exception e) {
            FCDocConverter.logger.log(Level.SEVERE, "Error", e);
        }
        return false;
    }
}

