/*
 * Decompiled with CFR 0.152.
 */
package com.codelathe.tools.pdfbox;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.multipdf.Overlay;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.util.Matrix;

public class PDFBoxAdapter {
    private static int maxFontSize = 50;
    private static int dpi = 96;
    private static int pageNoToConvert = 1;

    private PDFBoxAdapter() {
    }

    public static BufferedImage fileToThumb(String file, String ext, int width, int height) throws IOException {
        if ("tif".equals(ext) || "tiff".equals(ext) || "psd".equals(ext) || "sgi".equals(ext) || "tga".equals(ext)) {
            return PDFBoxAdapter.imagesToThumb(file, width, height);
        }
        return PDFBoxAdapter.pdfToThumb(file, width, height);
    }

    public static BufferedImage pdfToThumb(String pdfFile, int width, int height) throws IOException {
        try (PDDocument document = null;){
            document = PDDocument.load((File)new File(pdfFile));
            PDFRenderer renderer = new PDFRenderer(document);
            BufferedImage image = renderer.renderImageWithDPI(pageNoToConvert - 1, (float)dpi, ImageType.RGB);
            BufferedImage bufferedImage = PDFBoxAdapter.resizeImage(image, width, height);
            return bufferedImage;
        }
    }

    public static boolean pdfToImages(String pdfFile, int width, int height, OutputStream out) throws IOException {
        try (PDDocument document = null;){
            document = PDDocument.load((File)new File(pdfFile));
            int pageCount = document.getNumberOfPages();
            if (pageCount <= 0) {
                return false;
            }
            PDFRenderer renderer = new PDFRenderer(document);
            ZipOutputStream zos = new ZipOutputStream(out);
            int index = 0;
            while (index < pageCount) {
                BufferedImage image = renderer.renderImageWithDPI(index, (float)dpi, ImageType.RGB);
                ZipEntry entry = new ZipEntry("page" + (index + 1) + ".png");
                zos.putNextEntry(entry);
                ImageIO.write((RenderedImage)image, "png", zos);
                zos.closeEntry();
                ++index;
            }
            zos.close();
            return true;
        }
    }

    public static BufferedImage imagesToThumb(String tifFile, int width, int height) throws IOException {
        try (Object document = null;){
            BufferedImage image = ImageIO.read(new File(tifFile));
            BufferedImage bufferedImage = PDFBoxAdapter.resizeImage(image, width, height);
            return bufferedImage;
        }
    }

    public static boolean combinePDFs(String[] infiles, String outfile) {
        try {
            PDFMergerUtility mergePdf = new PDFMergerUtility();
            mergePdf.setDestinationFileName(outfile);
            String[] stringArray = infiles;
            int n = infiles.length;
            int n2 = 0;
            while (n2 < n) {
                String infile = stringArray[n2];
                mergePdf.addSource(infile);
                ++n2;
            }
            mergePdf.mergeDocuments(MemoryUsageSetting.setupTempFileOnly());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static BufferedImage resizeImage(BufferedImage srcImage, int width, int height) {
        Dimension newDimension = PDFBoxAdapter.getScaledDimension(srcImage.getWidth(), srcImage.getHeight(), width, height);
        int w = (int)newDimension.getWidth();
        int h = (int)newDimension.getHeight();
        BufferedImage newimg = new BufferedImage(w, h, srcImage.getType() == 0 ? 5 : srcImage.getType());
        Graphics2D g = newimg.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawImage(srcImage, 0, 0, w, h, null);
        g.dispose();
        return newimg;
    }

    private static Dimension getScaledDimension(int original_width, int original_height, int resize_width, int resize_height) {
        int new_width = original_width;
        int new_height = original_height;
        if (resize_width > 0 && original_width > resize_width) {
            new_width = resize_width;
            new_height = new_width * original_height / original_width;
        }
        if (resize_height > 0 && new_height > resize_height) {
            new_height = resize_height;
            new_width = new_height * original_width / original_height;
        }
        return new Dimension(new_width, new_height);
    }

    public static void watermarkPDF(String infile, String outfile, String text) throws IOException {
        PDDocument overlayDoc = PDFBoxAdapter.createOverlay(text);
        Throwable throwable = null;
        Object var5_6 = null;
        try (PDDocument baseDoc = PDDocument.load((File)new File(infile));){
            if (baseDoc.isEncrypted()) {
                throw new IOException("Encrypted documents are not supported for this example");
            }
            Overlay overlay = new Overlay();
            HashMap overlayGuide = new HashMap();
            overlay.setOverlayPosition(Overlay.Position.FOREGROUND);
            overlay.setInputPDF(baseDoc);
            overlay.setAllPagesOverlayPDF(overlayDoc);
            overlay.overlay(overlayGuide).save(outfile);
            baseDoc.close();
            overlayDoc.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static PDDocument createOverlay(String text) throws IOException {
        PDDocument document = new PDDocument();
        PDPage page = new PDPage();
        document.addPage(page);
        PDType1Font font = PDType1Font.HELVETICA;
        PDPageContentStream contentStream = new PDPageContentStream(document, page);
        PDFBoxAdapter.addTransparency(contentStream, page);
        PDFBoxAdapter.addWaterMark(text, (PDFont)font, contentStream, page);
        contentStream.close();
        return document;
    }

    private static void addTransparency(PDPageContentStream contentStream, PDPage page) throws IOException {
        PDResources resources = page.getResources();
        if (resources != null) {
            PDExtendedGraphicsState extendedGraphicsState = new PDExtendedGraphicsState();
            extendedGraphicsState.setNonStrokingAlphaConstant(Float.valueOf(0.5f));
            PDExtendedGraphicsState graphicsState = resources.getExtGState(COSName.TRANSPARENCY);
            if (graphicsState == null) {
                graphicsState = extendedGraphicsState;
            }
            contentStream.setGraphicsStateParameters(graphicsState);
        }
    }

    private static void addWaterMark(String text, PDFont font, PDPageContentStream content, PDPage page) throws IOException {
        int fontSize = PDFBoxAdapter.getMaxFontSize(text, font, (int)page.getMediaBox().getWidth());
        content.setNonStrokingColor(Color.LIGHT_GRAY);
        content.setFont(font, (float)fontSize);
        content.beginText();
        boolean pageIsLandscape = PDFBoxAdapter.isLandscape(page);
        Point2D.Float pageCenter = PDFBoxAdapter.getCenter(page);
        Point2D.Float offset = new Point2D.Float(0.0f, 0.0f);
        float textWidth = font.getStringWidth(text) * (float)fontSize / 1000.0f;
        if (pageIsLandscape) {
            float textX = pageCenter.x - textWidth / 2.0f + offset.x;
            float textY = pageCenter.y - offset.y;
            content.setTextMatrix(Matrix.getRotateInstance((double)1.5707963267948966, (float)textY, (float)textX));
        } else {
            float textX = pageCenter.x - textWidth / 2.0f + offset.x;
            float textY = pageCenter.y + offset.y;
            content.setTextMatrix(Matrix.getTranslateInstance((float)textX, (float)textY));
        }
        PDFBoxAdapter.rotatePage(content, page);
        content.showText(text);
        content.endText();
    }

    private static void rotatePage(PDPageContentStream content, PDPage page) throws IOException {
        PDRectangle cropBox = page.getCropBox();
        float tx = (cropBox.getLowerLeftX() + cropBox.getUpperRightX()) / 2.0f;
        float ty = (cropBox.getLowerLeftY() + cropBox.getUpperRightY()) / 2.0f;
        content.transform(Matrix.getTranslateInstance((float)tx, (float)ty));
        content.transform(Matrix.getRotateInstance((double)Math.toRadians(45.0), (float)0.0f, (float)0.0f));
        content.transform(Matrix.getTranslateInstance((float)(-tx), (float)(-ty)));
    }

    private static boolean isLandscape(PDPage page) {
        int rotation = page.getRotation();
        boolean isLandscape = rotation == 90 || rotation == 270;
        return isLandscape;
    }

    private static Point2D.Float getCenter(PDPage page) {
        PDRectangle pageSize = page.getMediaBox();
        boolean rotated = PDFBoxAdapter.isLandscape(page);
        float pageWidth = rotated ? pageSize.getHeight() : pageSize.getWidth();
        float pageHeight = rotated ? pageSize.getWidth() : pageSize.getHeight();
        return new Point2D.Float(pageWidth / 2.0f, pageHeight / 2.0f);
    }

    private static int getMaxFontSize(String text, PDFont font, int pageWidth) {
        int fontsize = 36;
        try {
            fontsize = 1000 * pageWidth / (int)font.getStringWidth(text);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fontsize > maxFontSize) {
            fontsize = maxFontSize;
        }
        return fontsize;
    }
}

