<?php

/**
 * Copyright (c) 2020 CodeLathe. All rights Reserved.
 * This file is part of FileCloud  https://www.filecloud.com
 */

namespace app\backupagent;

define('TONIDO_CLOUD_ROOT_DIR', realpath(__DIR__ . '/../..'));
require_once TONIDO_CLOUD_ROOT_DIR . DIRECTORY_SEPARATOR . 'src' . DIRECTORY_SEPARATOR . 'runtime.php';

if (is_readable(TONIDOCLOUD_CONFIG_PATH . DIRECTORY_SEPARATOR . 'backupagentconfig.php')) {
    require_once TONIDOCLOUD_CONFIG_PATH . DIRECTORY_SEPARATOR . 'backupagentconfig.php';
}

use CodeLathe\Application\LoggerFacade;
use CodeLathe\Core\Common\Utility\Utility;
use CodeLathe\Core\Infrastructure\Settings\SettingsManager;

//For security, agent for backupserver has to be explicitly enabled
if (!Utility::isBackupServerAppEnabled()) {
    LoggerFacade::error('Agent for backupserver not enabled');
    Utility::getXMLResult('op', '0', 'Agent for backupserver not enabled');
    return;
}

/* Do some validation */
if (!isset($_REQUEST['op']) || !Utility::isValidInput($_REQUEST['op'])) {
    Utility::getXMLResult('op', '0', 'Missing OP');
    exit;
}

$op = Utility::sanitizeString($_REQUEST['op']);

$apipassword = SettingsManager::getInstance()->getSetting('BACKUPAGENT_ACCESS_KEY', 'string', '');
$headers = apache_request_headers();
$clientauthtoken = isset($headers['X-Auth-Token']) ? $headers['X-Auth-Token'] : '';

global $g_log;
Utility::logEntry();

//validate admin API Key
if (empty($apipassword) || $apipassword === 'backuppassword' || $apipassword !== $clientauthtoken) {
    $g_log->logDebug('Client sent an invalid API key');
    header('HTTP/1.1 401 Unauthorized', true, 401);
    exit;
}

/* Process Request */
switch ($op) {
    case 'checkcapability':
        $ba = new BackupAgent();
        $ba->checkAgentCapability();

        break;

    case 'getbackupcategories':
        $ba = new BackupAgent();
        $ba->getBackupCategories();

        break;

    case 'getfilelisttobackup':
        $ba = new BackupAgent();
        $ba->getFileListToBackup();

        break;

    case 'preparedbdump':
        $ba = new BackupAgent();
        $ba->prepareDBDump();

        break;

    case 'getdbdumpstatus':
        $ba = new BackupAgent();
        $ba->getDBDumpStatus();

        break;

    case 'completedbdump':
        $ba = new BackupAgent();
        $ba->completeDBDump();

        break;

    case 'downloadfile':
        $ba = new BackupAgent();
        $ba->downloadFile();

        break;

    case 'uploadfile':
        $ba = new BackupAgent();
        $ba->uploadFile();

        break;

    default:
        Utility::getXMLResult('op', '0', 'Invalid OP');
        exit;
}
