<?php
define('TONIDO_CLOUD_ROOT_DIR', realpath(__DIR__ . '/..'));
require_once(TONIDO_CLOUD_ROOT_DIR . DIRECTORY_SEPARATOR . 'src' . DIRECTORY_SEPARATOR . 'runtime.php');

use CodeLathe\Core\Infrastructure\Settings\SettingsManager;
use CodeLathe\Core\Subsystem\User\User\SSO\SSOManager;
use CodeLathe\Application\Response\ResponseManager;
use CodeLathe\Application\ContainerFacade;
use CodeLathe\Application\ResponseEmitter;

/*
 * This path will be invoked only when NTLM sso is configured in Apache using Location directive
 * This path will not used for saml sso logins, which goes through slim routing
 */
$ssotype = SettingsManager::getInstance()->getSetting("TONIDOCLOUD_SSO_DEFAULT", "string", "NONE");
$ssoManager = ContainerFacade::get(SSOManager::class);
$responseManager = ContainerFacade::get(ResponseManager::class);

if($ssotype === 'NTLM'){
    $data = $ssoManager->userNtlmSSOLogin();
    $responseEmitter = new ResponseEmitter();
    $responseEmitter->emitDataHolder($data);
} else{
    exit('Forbidden');
}
