<?php
/**
 * Copyright (c) 2020 CodeLathe. All rights Reserved.
 * This file is part of FileCloud  https://www.filecloud.com
 */

/*
 *  Configuration values for Multiple SAML SSO Identity Providers
 *  The first identity provider will be added in the UI.
 *  Up to 5 additional identity providers can be added here with suffix _1 _2 etc for each configuration parameter.
 */

/*
  comma separated set the email domains that must use the configurations with _1
  Example xyz.com,abc.com
*/
define("TONIDOCLOUD_SAML_EMAIL_DOMAINS_1","");

/* set the idp url starting with http:// or https:// */
define("TONIDOCLOUD_SAML_IDP_URL_1","");

/* set the claims for username, email, given Name and surname */
define("TONIDOCLOUD_SAML_USERNAME_PARAM_1", "uid");
define("TONIDOCLOUD_SAML_EMAIL_PARAM_1", "mail");
define("TONIDOCLOUD_SAML_GIVENNAME_PARAM_1", "givenName");
define("TONIDOCLOUD_SAML_SURNAME_PARAM_1", "sn");

/* (Optional) Logout URL for this IDP starting with http:// or https:// */
define("TONIDOCLOUD_SAML_IDP_LOGOUT_URL_1","");

/* Is the IDP - ADFS based? 0 (false) or 1 (true)*/
define("TONIDOCLOUD_SAML_ADFS_1","0");

/* Support SAML authentication for only Limit Group Members. Enter Limit Group Name */
define("TONIDOCLOUD_SAML_LIMIT_GROUP_1","");

/* metadata in xml format. Ensure the double quotes are escaped if double quotes are used
   or use single quote to wrap the content. */
define("TONIDOCLOUD_SAML_IDP_METADATA_1",'');

/* Enter Message template to be used when SSO login fails in HTML format with ^MESSAGE^ as a place holder (Optional) */
define("TONIDOCLOUD_SAML_ERROR_MSG_1",'');

/* Optional If set to true (1), user authentication token will expire as specified by Identity Provider.
   If set to false (0) the user authentication token will expire based on FileCloud token expiration */
define("TONIDOCLOUD_SSO_TIMEOUT_MODE_1","0");

/* Allow new account to be created during the login process, when authenticated through this IDP
    allowed values FALSE or TRUE */
define("TONIDOCLOUD_SAML_ACCOUNT_CREATION_MODE_1","FALSE");

/*
Set Status of new accounts created automatically when authenticated through this IDP
0 - No Automatic approval, Admin has to approve account
1 - Automatically approve new accounts to Full User
2 - Automatically approve new accounts to Guest User
3 - Automatically approve new accounts to External User
*/
define("TONIDOCLOUD_SAML_AUTOMATIC_ACCOUNT_APPROVAL_1","1");


