<?php
/**
 * Copyright (c) 2020 CodeLathe. All rights Reserved.
 * This file is part of FileCloud  https://www.filecloud.com
 */

use CodeLathe\Application\ContainerFacade;
use CodeLathe\Application\Service\LoggerService;
use CodeLathe\Core\Infrastructure\Database\CLMongo\CLMongoDatabase;
use CodeLathe\Core\Common\Utility\Utility;
use PHPMailer\PHPMailer\PHPMailer;
use tools\mongohealth\Checker;

define('TONIDO_CLOUD_ROOT_DIR', realpath(__DIR__ . '/../../..'));

spl_autoload_register(
    function (string $className): void {
        if (strpos($className, 'MongoDB\\') !== false) {
            $replacedClass = str_replace('\\', DIRECTORY_SEPARATOR, $className);
            $filePath = TONIDO_CLOUD_ROOT_DIR . DIRECTORY_SEPARATOR . 'thirdparty' . DIRECTORY_SEPARATOR
                . 'mongo-php-library' . DIRECTORY_SEPARATOR . $replacedClass . '.php';
            require_once $filePath;
        }
    }
);

// ... Load Config
require_once TONIDO_CLOUD_ROOT_DIR . DIRECTORY_SEPARATOR . 'localconfig.php';
require_once TONIDO_CLOUD_ROOT_DIR . DIRECTORY_SEPARATOR . 'src' . DIRECTORY_SEPARATOR . 'autoload.php';
require_once realpath(__DIR__) . DIRECTORY_SEPARATOR . 'checker.class.php';
require_once realpath(__DIR__) . DIRECTORY_SEPARATOR . 'status.class.php';
require_once realpath(__DIR__) . DIRECTORY_SEPARATOR . 'email.class.php';

date_default_timezone_set(TONIDOCLOUD_DEFAULT_TIMEZONE);

// ... Old versions of PHP before 5.6 didn't set the internal encoding properly
// ... So we explicity set it if needed, otherwise mb_strtolower didn't work
if (version_compare(phpversion(), '5.6', '<') || defined('TONIDOCLOUD_SET_INTERNAL_ENCODING')) {
    if (mb_internal_encoding() != 'UTF-8') {
        mb_internal_encoding('UTF-8');
    }
}

if (php_sapi_name() == 'cli') {
    /** @var LoggerService $loggerService */
    $loggerService = ContainerFacade::get(LoggerService::class);
    $loggerService->debug('CRON: MongoDB cluster Health check');

    $dbConnection = Utility::getMongoConnection(TONIDOCLOUD_DBSERVER);
    /** @var CLMongoDatabase $db */
    $db = $dbConnection->selectDB('admin');

    $replyTo = defined('TONIDOCLOUD_REPLY_TO_EMAIL') ? TONIDOCLOUD_REPLY_TO_EMAIL : '';
    $checker = new Checker(
        new \tools\mongohealth\Email(
            new PHPMailer(),
            $replyTo,
            $loggerService
        ),
        $db,
        $loggerService
    );
    $checker->check();
} else {
    echo '<html><body><h3>Cannot be executed via a Webserver</h3></body></html>';
}
