# README

This directory contains security tools for generating cryptographically secure random numbers, encryption, decryption, hashing, etc.

## Generating a secure encryption key

```shell
# Generate a cryptographically random set of bytes and store it in a file
./genkey.php > securekey.key
```

## Encrypting data

```shell
# Encrypt a message using the specified key
./fcencrypt.php --message "aSecretPassword" --key "securekey.key"
Encrypted message: PgxQKdMU+k5756194hlIcUcp5Qod7oXe2XgaQNO+qri9nHIoTBVYBA7PuLthEu7Eq+Mx4vZ/vQ==
```

## Decrypting data

```shell
# Decrypt a message using the specified key
./fcdecrypt.php --message "PgxQKdMU+k5756194hlIcUcp5Qod7oXe2XgaQNO+qri9nHIoTBVYBA7PuLthEu7Eq+Mx4vZ/vQ==" --key "securekey.key"
Decrypted message: aSecretPassword
```

### Note when using encrypted DB password

Config values for `TONIDOCLOUD_DBSERVER`, `TONIDOCLOUD_AUDIT_DBSERVER`, and `TONIDOCLOUD_SETTINGS_DBSERVER` settings will not be honored when using the encrypted password feature since it is supported only in `FC_MONGODB_URI_OPTIONS`.

## Encrypting a secure password for AD configs

```shell
$ php ./adpasswordencryption.php
This tool encrypts an AD password string
to be used in the adconfig.php configuration files of FileCloud

Enter your password: password-string
Carefully copy paste the following string to adconfig.php key TONIDOCLOUD_AD_ENC_ACCOUNTPASSWORD or TONIDOCLOUD_AD_ENC_ADMINACCOUNTPASSWORD:
zk8aQV6+L1Q7kA7N6JGgj2MzNjRkNzMwMTU0OTY0MjAzMGVhNWI0NDM5NjIxMWI2N2UzMzRkZTcwNjE2YzgxOTk0YzVjNjI2ZGQ2NjgzMTZ1bTJBN0gwdmdabHYzQzlmQm9IZUN3PT0=


Finished
```