## FileCloud User Auth MiddleWare

#### Class Information
##### UserAuthMiddleware
This is a global middleware class and will be used to check authentication of all calls into user endpoints.

##### AuthFactory
This is a factory to provide various available authentication validators. Each factory object will be of type **AuthValidatorInterface**
Any new type of authentication validator will have be registered to the factory

##### Traits
The traits can be reused in any of the Validators to validate the authentication credentials

*UserAccessValidatorTrait* - Checks if the provided authentication data is for a FileCloud User (Supports Full, Guest and Limited users)

*AdminAccessValidatorTrait* - Checks if the authentication is using built in Admin account with user impersonation. If user impersonation is not 
done, the authentication will ignore Admin credentials

*ShareAccessValidatorTrait* - Checks if the authentication is to access a shared link. This could be a password protected share access or public share access.

#### CookieAuthValidator
This class will extract cookie data and will use the traits listed earlier to validate cookies.

#### JwtAuthValidator
This class will use JWT token header and can potentially use the traits to validate the JWT token (Which can have the same data as the cookies).

#### ParamAuthValidator
This class can validate authentication credentials sent in via POST or GET. Cookies, for example can be sent via these methods.


#### Class Diagram
![Class Diagram](./UserAuthMiddleawareClassDiagram.png)
