In order to add new htaccess update steps, we need to add new classes implementing HtaccessVerificationFilterInterface,
following the naming convention of adding incremental number in the new class's name.
For example HtaccessVerificationFilter2, HtaccessVerificationFilter3, and so on.
The new classes will be picked automatically by the HtaccessVerificationFiltersCreator class.
This class will verify which is the latest existing filter class (e.g. with highest number in its name), starting from a
given number, which will be passed by HtaccessManager, and is intended to be the current version number we have stored
in the database.

Main process

- get current version number from DB
- get latest available number (check existing filter classes from current number on)
- if latest <= current return ok
- backup htaccess
- get htaccess contents
- get filter objects from current version till latest
- apply filters one by one (operating on the original htaccess content string)
- write the resulting string in the htaccess file
- save latest number as new current version in the db