/*
 * Copyright (c) 2024 FileCloud. All rights Reserved.
 * This file is part of FileCloud https://www.filecloud.com
 */

const winston = require('winston');
const { format } = winston;

const logger = winston.createLogger({
    format: format.combine(
        format.timestamp(),
        format.printf(i => `[${i.level}] ${i.timestamp} | ${i.message}`)
    ),
    defaultMeta: { service: 'mqworker' },
    transports: [
        //
        // - Write all logs with level `debug` and below to console
        // - Write all logs with level `info` and below to `combined.log`
        // - Write all logs error (and below) to `error.log`.
        //
        new winston.transports.Console({
            colorize: true,
            json: false,
            level: 'debug',
        })
    ]
});


module.exports = logger;