<?php

/**
 * This script pre-process the top1000000 list of most commonly used passwords, ordering the file, making the searches
 * on it faster
 */

define('LISTFILENAME', 'top1000000');
define('ITEMSEPARATOR', chr(10));

$file = __DIR__ . DIRECTORY_SEPARATOR;
$file.= $argv[1] ?? LISTFILENAME;

$separator = $argv[2] ?? ITEMSEPARATOR;

$originalList =  trim(file_get_contents($file));
$list = explode($separator, $originalList);
sort($list, SORT_STRING);

if (file_put_contents($file, implode($separator, $list)) !== false) {
    echo 'File pre-processed successfully!';
} else {
    echo 'Failed pre-processing the file!';
}

echo PHP_EOL;