<?php

/* **********************************************************************
 * INSTRUCTIONS TO UPDATE SIMPLESAML MODULE
 * **********************************************************************
 * Gets the Configuration parameters for Config file inside simplesaml.
 * When SimpleSAML is updated, this file must be copied.
 * 
 * Custom Files and Modified Files inside SimpleSAML.
 * 
 * 1. /config/config.php (modified)
 * 2. /config/authsources.php (modified)
 * 3. /config/filecloudconfig.php (New)
 * 4. /lib/metadata/metadatastoragehandlerxmlstring.php (new)
 * 5. /lib/metadata/metadatastoragesource.php (moified)
 */

/*
 * Add the Proxy Server Information here
 * Format is as follows user:password@proxyserverurl.com
 */

define("TONIDOCLOUD_SAML_PROXY", "");

use CodeLathe\Core\Infrastructure\Settings\SettingsManager;
use CodeLathe\Application\LoggerFacade;
use CodeLathe\Application\ContainerFacade;

class FilecloudConfigHelper
{
    protected static array $samlConfig = [];

    /**
     * Function to load IDP metadata using direct function calls instead of curl
     * @return string
     * @throws \CodeLathe\Core\Common\Exception\TonidoCloudException
     */
    public static function getIdpMetaData(): ?string
    {
        /** @var \CodeLathe\Core\Subsystem\Security\Auth\SSO\SamlSSO $samlSSO */
        $samlSSO = ContainerFacade::get(\CodeLathe\Core\Subsystem\Security\Auth\SSO\SamlSSO::class);
        $params = self::getFunctionParams();

        $xmlMetaData = $samlSSO->getIdpMetaData($params['autofillvalue']??null,
            $params['entityid']??null);
        return $xmlMetaData;
    }

    /**
     * Function to load IDP samlconfing using direct function calls instead of curl
     * @return array
     */
    public static function getFileCloudSamlConfig(): array
    {
        if (self::$samlConfig) {
            return self::$samlConfig;
        }

        /** @var \CodeLathe\Core\Subsystem\Security\Auth\SSO\SamlSSO $samlSSO */
        $samlSSO = ContainerFacade::get(\CodeLathe\Core\Subsystem\Security\Auth\SSO\SamlSSO::class);
        $params = self::getFunctionParams();

        self::$samlConfig = $samlSSO->getSamlConfig($params['autofillvalue']??null,
            $params['entityid']??null);
        return self::$samlConfig;
    }

    /**
     * Function that returns incoming request params as an array
     * @return array
     */
    public static function getFunctionParams(): array
    {
        $params = [];
        if (isset($_REQUEST['RelayState'])) {
            $queryString = parse_url($_REQUEST['RelayState'], PHP_URL_QUERY);
            if ($queryString) {
                parse_str($queryString, $params);
            }
        }
        else if (isset($_REQUEST['autofillvalue'])){
            $params['autofillvalue'] = trim($_REQUEST['autofillvalue']);
        }
        return $params;
    }

    /**
     * Get the SamlConfiguration from the mongodb
     */
    public static function getFileCloudConfig()
    {
        $result = array ('idpurl' => '', 'contactemail' => '', 'contactname' => '', 'adfs' => '', 'logmode' => '',
            'baseserverurl' => '', 'samlcertdir' => 'cert/', 'memcacheserver' => 'localhost', 'memcacheprefix' => '');

        $xmlresponse = self::getCurlResponse("getsamlconfig");

        if ($xmlresponse == null)
        {
            \SimpleSAML\Logger::error(__FUNCTION__ . " Exception: Unable to read from /url/core/getsamlconfig data");
            return $result;
        }

        $xml = simplexml_load_string($xmlresponse);

        if (!$xml)
        {
            \SimpleSAML\Logger::error(__FUNCTION__ . " Exception: Invalid xml format from /url/core/getsamlconfig data");
            return $result;
        }

        if (isset($xml->item[0]->idpurl))
        {
            $result['idpurl'] = (string)$xml->item[0]->idpurl;
        }

        if (isset($xml->item[0]->contactemail))
        {
            $result['contactemail'] = (string)$xml->item[0]->contactemail;
        }

        if (isset($xml->item[0]->contactname))
        {
            $result['contactname'] = (string)$xml->item[0]->contactname;
        }

        if (isset($xml->item[0]->adfs))
        {
            $result['adfs'] = (string)$xml->item[0]->adfs;
        }

        if (isset($xml->item[0]->logmode))
        {
            $result['logmode'] = (string)$xml->item[0]->logmode;
        }

        if (isset($xml->item[0]->baseserverurl))
        {
            $result['baseserverurl'] = (string)$xml->item[0]->baseserverurl;
        }

        if (isset($xml->item[0]->samlcertdir))
        {
            $result['samlcertdir'] = (string)$xml->item[0]->samlcertdir;
        }

        if (isset($xml->item[0]->memcacheserver))
        {
            $result['memcacheserver'] = (string)$xml->item[0]->memcacheserver;
        }

        if (isset($xml->item[0]->logmode))
        {
            $result['memcacheprefix'] = (string)$xml->item[0]->memcacheprefix;
        }

        \SimpleSAML\Logger::info(print_r($result,TRUE));

        return  $result;
    }

    /**
     * Get the curl response for metadata or samlconfig etc.
     */
    public static function getCurlResponse($command)
    {
        LoggerFacade::debug(__FUNCTION__ . " Attempting Curl Command $command in SimpleSaml");
        $hostName = "";
        $protocol = "http";
        $proxyurl = "";
        $proxyauth = "";

        if( isset($_SERVER['HTTPS']))
        {
            $protocol = "https";
        }
        if (isset($_SERVER['HTTP_HOST']))
        {
            $hostName = $_SERVER['HTTP_HOST'];
        }

        //08-31-2020: This change was added to support cases where proxy overrides the request params with values
        //it received from the client. Such overrides will cause curl call back into FC to fail
        $ssofullurloverride = SettingsManager::getInstance()->getSetting("TONIDOCLOUD_SSO_FULLURL_OVERRIDE", "string", "");
        $useserverurlforsso = SettingsManager::getInstance()->getSetting("TONIDOCLOUD_SSO_USE_SERVER_URL", "bool", false);
        if(!empty($ssofullurloverride)){
            $serverURL = $ssofullurloverride;
        } else if($useserverurlforsso){
            $serverURL = SettingsManager::getInstance()->getSetting("TONIDOCLOUD_SERVER_URL");
        } else{
            $serverURL = $protocol . '://' . $hostName;
        }

        $params = self::getQueryParams();
        $url = $serverURL . "/core/" . $command . $params;
        LoggerFacade::debug(__FUNCTION__ . " Idp Info got from URL $url");
        if (defined("TONIDOCLOUD_SAML_PROXY"))
        {
            if (TONIDOCLOUD_SAML_PROXY !== "")
            {
                LoggerFacade::debug(__FUNCTION__ . " Proxy enabled for SimpleSAML");

                $protected = strpos(TONIDOCLOUD_SAML_PROXY, '@');
                if ($protected === false)
                {
                    $proxyurl = TONIDOCLOUD_SAML_PROXY;
                }
                else
                {
                    $exploded = explode('@', TONIDOCLOUD_SAML_PROXY);
                    $proxyauth = $exploded[0];
                    $proxyurl = $exploded[1];
                }
            }
        }

        // initialize curl
        $curl = curl_init();

        curl_setopt($curl, CURLOPT_URL, $url);

        //proxy settings if applicable
        if ($proxyurl != "")
        {
           curl_setopt($curl, CURLOPT_PROXY, $proxyurl);
           if ($proxyauth != "")
           {
               curl_setopt($curl, CURLOPT_PROXYUSERPWD, $proxyauth);
           }
        }

        // return the curl response to be captured in a variable.
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

        // wait max of 10 seconds for connection to be established
        curl_setopt($curl, CURLOPT_CONNECTTIMEOUT ,10);

        // We dont care about https here because no secret data is transfered here.
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);

        // get the httpcode for later verification
        $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        if(!$response = curl_exec ($curl))
        {
            echo "SAML Curl Request Failed.  HTTP code: $httpCode. Curl ERR: " . curl_error($curl) . " [Curl Error no " . curl_errno($curl) . "]";
            return null;
        }

        curl_close($curl);
        return $response;
    }

    public static function getQueryParams(): string
    {
        if (isset($_REQUEST['RelayState'])) {
            $relayStateUrl = $_REQUEST['RelayState'];
            $queryString = parse_url($relayStateUrl, PHP_URL_QUERY);
            return '?' . $queryString;
        }

        if (isset($_REQUEST['autofillvalue'])) {
            return "?autofillvalue=" . trim($_REQUEST['autofillvalue']);
        }

        return '';
    }
}