<?php


/* Load simpleSAMLphp, configuration */
$config = \SimpleSAML\Configuration::getInstance();
$session = \SimpleSAML\Session::getSessionFromRequest();
$simpleSAMLUtilAuth = new \SimpleSAML\Utils\Auth();

/**
 * @info `admin.protectindexpage`. Replaced by the admin module which always requires login. https://simplesamlphp.org/docs/stable/simplesamlphp-upgrade-notes-2.0.html
 */
///* Check if valid local session exists.. */
//if ($config->getBoolean('admin.protectindexpage')) {
//    $simpleSAMLUtilAuth->requireAdmin();
//}

/** @info Method getAdminLoginURL was removed from \SimpleSAML\Utils\Auth */
//$loginurl = \SimpleSAML\Utils\Auth::getAdminLoginURL();
$isadmin = $simpleSAMLUtilAuth->isAdmin();

$links = [];
$links_welcome = [];
$links_config = [];
$links_auth = [];
$links_federation = [];

if ($config->getBoolean('idpdisco.enableremember')) {
    $links_federation[] = [
        'href' => 'cleardiscochoices.php',
        'text' => '{core:frontpage:link_cleardiscochoices}',
    ];
}

$links_federation[] = [
    'href' => $this->data['baseurlpath'] . 'admin/metadata-converter.php',
    'text' => '{core:frontpage:link_xmlconvert}',
];

$allLinks = [
    'links' => &$links,
    'welcome' => &$links_welcome,
    'config' => &$links_config,
    'auth' => &$links_auth,
    'federation' => &$links_federation,
];
/**
 * @info frontpage : replace with configpage https://simplesamlphp.org/docs/stable/simplesamlphp-upgrade-notes-2.0.html
 */
\SimpleSAML\Module::callHooks('configpage', $allLinks);

$metadataHosted = [];
/**
 * @info metadata_hosted is no longer supported (metadata_hosted : no replacement) https://simplesamlphp.org/docs/stable/simplesamlphp-upgrade-notes-2.0.html
 */
//\SimpleSAML\Module::callHooks('metadata_hosted', $metadataHosted);

$metadata = \SimpleSAML\Metadata\MetaDataStorageHandler::getMetadataHandler();

$metaentries = ['hosted' => $metadataHosted, 'remote' => []];

if ($isadmin) {
    $metaentries['remote']['saml20-idp-remote'] = $metadata->getList('saml20-idp-remote');
    //$metaentries['remote']['shib13-idp-remote'] = $metadata->getList('shib13-idp-remote');
}

if ($config->getBoolean('enable.saml20-sp') === true) {
    try {
        $metaentries['hosted']['saml20-sp'] = $metadata->getMetaDataCurrent('saml20-sp-hosted');
        $metaentries['hosted']['saml20-sp']['deprecated'] = true;
        /**
         * @info "\SimpleSAML\Configuration::getBaseURL() is deprecated, please use getBasePath() instead."
         */
        $metaentries['hosted']['saml20-sp']['metadata-url'] = '/' . $config->getBasePath() .
            'saml2/sp/metadata.php?output=xhtml';
    } catch (Exception $e) {
    }
}
if ($config->getBoolean('enable.saml20-idp') === true) {
    try {
        $metaentries['hosted']['saml20-idp'] = $metadata->getMetaDataCurrent('saml20-idp-hosted');
        $metaentries['hosted']['saml20-idp']['metadata-url'] = '/' . $config->getBasePath() .
            'saml2/idp/metadata.php?output=xhtml';
        if ($isadmin) {
            $metaentries['remote']['saml20-sp-remote'] = $metadata->getList('saml20-sp-remote');
        }
    } catch (Exception $e) {
    }
}
/**
 * @info shib13 is no longer supported
 */
//if ($config->getBoolean('enable.shib13-sp') === true) {
//    try {
//        $metaentries['hosted']['shib13-sp'] = $metadata->getMetaDataCurrent('shib13-sp-hosted');
//        $metaentries['hosted']['shib13-sp']['deprecated'] = true;
//        $metaentries['hosted']['shib13-sp']['metadata-url'] = '/' . $config->getBasePath() .
//            'shib13/sp/metadata.php?output=xhtml';
//    } catch (Exception $e) {
//    }
//}
//if ($config->getBoolean('enable.shib13-idp') === true) {
//    try {
//        $metaentries['hosted']['shib13-idp'] = $metadata->getMetaDataCurrent('shib13-idp-hosted');
//        $metaentries['hosted']['shib13-idp']['metadata-url'] = '/' . $config->getBasePath() .
//            'shib13/idp/metadata.php?output=xhtml';
//        if ($isadmin) {
//            $metaentries['remote']['shib13-sp-remote'] = $metadata->getList('shib13-sp-remote');
//        }
//    } catch (Exception $e) {
//    }
//}
if ($config->getBoolean('enable.adfs-idp') === true) {
    try {
        $metaentries['hosted']['adfs-idp'] = $metadata->getMetaDataCurrent('adfs-idp-hosted');
        $metaentries['hosted']['adfs-idp']['metadata-url'] = \SimpleSAML\Module::getModuleURL(
            'adfs/idp/metadata.php',
            ['output' => 'xhtml']
        );
        if ($isadmin) {
            $metaentries['remote']['adfs-sp-remote'] = $metadata->getList('adfs-sp-remote');
        }
    } catch (Exception $e) {
    }
}

$t = new \SimpleSAML\XHTML\Template($config, 'core:frontpage_federation.tpl.php');
$t->data['pageid'] = 'frontpage_federation';
$t->data['isadmin'] = $isadmin;
//$t->data['loginurl'] = $loginurl;


//$t->data['links'] = $links;
//$t->data['links_welcome'] = $links_welcome;
//$t->data['links_config'] = $links_config;
//$t->data['links_auth'] = $links_auth;
//$t->data['links_federation'] = $links_federation;


$t->data['metaentries'] = $metaentries;

/**
 * @info show changed to send
 */
$t->send();

