window.$driver = {};

// send message to parent window
window.$driver.send = function(action, data) {
  if(window.parent) {
    window.parent.postMessage(JSON.stringify({ action, data }, "*"));	
    return true;
  } else {
    console.error("Failed to send message to parent window", { action, data });
    return false;
  }
}

// send message to parent window
window.$driver.request = function(type, data, timeout) {
  return new Promise(function(resolve) {
    if(window.parent) {
          
      let timeoutCallback = setTimeout(() => {
        resolve("");
      }, timeout ? timeout : 1000);
      
      // listen for the response
      window.addEventListener("message", function(e) {
        
        // validate event origin      
        if (e.origin !== window.location.origin) return;
        
        if(!e.data || typeof e.data !== 'string') return;
        
        const payload = JSON.parse(e.data);
        
        if(payload.action === 'response' && payload.type === type) {
          clearTimeout(timeoutCallback);
          resolve(payload.data)
        }
              
      });
          
      window.parent.postMessage(JSON.stringify({ action: "request", type: type, data: data }, "*"));	
    
      return true;
    } else {
      console.error("Failed to send request to parent window", type, data);
      reject("Failed to send request to parent window");
    }
  })
}				

// modal addEventListener
jQuery(document).on('show.bs.modal', function (e) {
  if(e.target.className.includes('modal')) {
    window.$driver.send('modalOpen');
  }
});

jQuery(document).on('hide.bs.modal', function (e) {
  if(e.target.className.includes('modal')) {
    window.$driver.send('modalClose');
  }
});

/*
// listen to the history
window.onpopstate = (e) => {      
  console.log("[ROUTER]", e.target.location.href);
}
*/

const TOAST_TYPES = {
  '#3276B1': 'info',
  '#C79121': 'warning',
  '#C46A69': 'error',
  '#739E73': 'success',
}

window.onload = async () => {
  await waitForToastsPlugin();
  // override default toast plugin so it can be handled by new ui
  $.smallBox = (params) => {
    const { title, color, content, timeout } = params;
    window.$driver.send('toast', {
      type: TOAST_TYPES[color] || "info", // defaults to info tooltip
      title,
      content,
      timeout,
    });
  }
}

window.onbeforeunload = () => {
  window.$driver.send('unload');
};

async function waitForToastsPlugin(ms = 100) {
  return new Promise((resolve) => {
    const interval = setInterval(() => {
      if(isToastsPluginLoaded()) {
        clearInterval(interval);
        resolve();
      }
    }, ms);
  });
}

function isToastsPluginLoaded() {
  return !!$.smallBox;
}