# PDF.js

[PDF.js](https://mozilla.github.io/pdf.js/) is a Portable Document Format (PDF) viewer that is built with HTML5.

This library runs version v2.16.105 with some custom modifications made for FileCloud.

Most of the changes made to support the FileCloud are in `web/fcoverrides.js`.

For upgrading this library, follow the steps:
- Get the library zip [here](https://github.com/mozilla/pdf.js/releases) and unzip the lib;
- import the  `fcoverrides.js` and `jquery-1.11.2.min.js` files in `web/viewer.html`:
```html
// [...]
<script src="../build/pdf.js"></script>

  <script src="viewer.js"></script>
  <script src="jquery-1.11.2.min.js"></script>
  <script src="fcoverrides.js"></script>

  </head>
// [...]
```
- Copy `fcoverrides.js` and `jquery-1.11.2.min.js` from this version to `/web` folder;
- Emit the event `PDFEventBusReady` after the PDFJS lib starts the event bus. You can use this version as a reference.
```js
    // web\viewer.js:1951
    const eventBus = externalServices.isInAutomation // [...]
    this.eventBus = eventBus;
    
    // FILECLOUD OVERRIDE
    const eventBusReadyEvent = new Event('PDFEventBusReady');
    window.dispatchEvent(eventBusReadyEvent);
    // FILECLOUD OVERRIDE END
```
- Make sure the PDFJS API works, a few methods may change with the versions. test the API methods used in the ´fcoverrides.js´