var switchtoromode = function(){
	$('head').append("<style type='text/css'  media='print'> body { visibility: hidden; display:none; }</style>");
	$('#print').hide();
	$('#secondaryPrint').hide();
	$('#download').hide();
	$('#secondaryDownload').hide();
	$('#secondaryOpenFile').hide();
	$('#viewBookmark').hide();
	
	PDFViewerApplication.preferences.set('textLayerMode', 0);
}

//function to disable keyboard shortcuts in readonly mode
// - ctrl+s shortcut (save file) 
var disablekeymappings = function(evt){
	var cmd = (evt.ctrlKey ? 1 : 0) | (evt.altKey ? 2 : 0) | (evt.shiftKey ? 4 : 0) | (evt.metaKey ? 8 : 0);
	if (cmd === 1 || cmd === 8) {
		switch (evt.keyCode) {
			case 83:
				evt.preventDefault();
				if (evt.stopImmediatePropagation) {
					evt.stopImmediatePropagation();
				} else {
					evt.stopPropagation();
				}
		}
	}
}

//function to disable context menu
var disablecontextmenu = function(evt){
	evt.preventDefault();
	if (evt.stopImmediatePropagation) {
		evt.stopImmediatePropagation();
	} else {
		evt.stopPropagation();
	}
}

var getUrlParameter = function getUrlParameter(sParam) {
    var sPageURL = decodeURIComponent(window.location.search.substr(1)),
        sURLVariables = sPageURL.split('&'),
        sParameterName,
        i;

    for (i = 0; i < sURLVariables.length; i++) {
        sParameterName = sURLVariables[i].split('=');

        if (sParameterName[0] === sParam) {
            return sParameterName[1] === undefined ? true : sParameterName[1];
        }
    }
};

var onLoad = function(){
	var windowname = self.window.name;
	var framename = "";
	var userAgent = window.navigator.userAgent.toLowerCase(), mobile = /mobile/.test( userAgent );
	if(self.window.frameElement != null){
		framename = self.window.frameElement.getAttribute("name");
	}
	if( windowname == "readonly" || framename == "readonly" || mobile ){
		switchtoromode();
		window.addEventListener('keydown', disablekeymappings);
		window.addEventListener('contextmenu', disablecontextmenu);
	}

	//open all links in new window
	PDFViewerApplication.preferences.set('externalLinkTarget', PDFViewerApplicationConstants.LinkTarget.BLANK);
}

var onPageInit = function(){
	// showPreviousViewOnLoad
	PDFViewerApplication.page = 1;
}

var onPageLoad = function(){
	//set title
	var filepath = getUrlParameter('name');
	this.title=decodeURIComponent(filepath);

	// Disable open file button
	$('#openFile').hide();
}
document.addEventListener('DOMContentLoaded', onLoad, true);

// PDFJS no longer emits events in DOM, it uses a eventbus, present in PDFViewerApplication.
// To make the code compatible, we had to modify the web/viewer.js:1954, emitting an event after the eventbus is initialized
window.addEventListener('PDFEventBusReady', () => {
	PDFViewerApplication?.eventBus?.on('pagesinit', onPageInit);
	PDFViewerApplication?.eventBus?.on('pagesloaded', onPageLoad);
});
